/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;

public class ScanInfoUtil {
    private ScanInfoUtil() {
    }

    public static boolean isKeepDeletedCells(ScanInfo scanInfo) {
        return scanInfo.getKeepDeletedCells() != KeepDeletedCells.FALSE;
    }

    public static ScanInfo cloneScanInfoWithKeepDeletedCells(ScanInfo scanInfo) {
        return new ScanInfo(scanInfo.getConfiguration(), scanInfo.getFamily(), Math.max(scanInfo.getMinVersions(), 1), scanInfo.getMaxVersions(), scanInfo.getTtl(), KeepDeletedCells.TRUE, scanInfo.getTimeToPurgeDeletes(), scanInfo.getComparator());
    }

    public static StoreScanner createStoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        if (!scan.isReversed()) {
            return new StoreScanner(store, scanInfo, scan, columns, readPt);
        }
        return new ReversedStoreScanner(store, scanInfo, scan, columns, readPt);
    }
}

