/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.DataTableLocalIndexRegionScanner;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.IndexHalfStoreFileReader;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.LocalIndexStoreFileScanner;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.ReversedStoreScanner;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.index.IndexMaintainer;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.RepairUtil;

public class IndexHalfStoreFileReaderGenerator
extends BaseRegionObserver {
    private static final String LOCAL_INDEX_AUTOMATIC_REPAIR = "local.index.automatic.repair";
    public static final Log LOG = LogFactory.getLog(IndexHalfStoreFileReaderGenerator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StoreFile.Reader preStoreFileReaderOpen(ObserverContext<RegionCoprocessorEnvironment> ctx, FileSystem fs, Path p, FSDataInputStreamWrapper in, long size, CacheConfig cacheConf, Reference r, StoreFile.Reader reader) throws IOException {
        PhoenixConnection conn;
        byte[] regionStartKeyInHFile;
        byte[] splitKey;
        HRegionInfo childRegion;
        block37: {
            TableName tableName = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDesc().getTableName();
            Region region = ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion();
            childRegion = region.getRegionInfo();
            splitKey = null;
            if (reader != null) return reader;
            if (r == null) return reader;
            if (!p.toString().contains("L#")) {
                return super.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, reader);
            }
            Scan scan = MetaTableAccessor.getScanForTableName((TableName)tableName);
            SingleColumnValueFilter scvf = null;
            if (Reference.isTopFileRegion((Reference.Range)r.getFileRegion())) {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITB_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            } else {
                scvf = new SingleColumnValueFilter(HConstants.CATALOG_FAMILY, HConstants.SPLITA_QUALIFIER, CompareFilter.CompareOp.EQUAL, region.getRegionInfo().toByteArray());
                scvf.setFilterIfMissing(true);
            }
            if (scvf != null) {
                scan.setFilter((Filter)scvf);
            }
            regionStartKeyInHFile = null;
            conn = null;
            try (HTable metaTable = null;){
                metaTable = new HTable(((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration(), TableName.META_TABLE_NAME);
                Result result = null;
                try (ResultScanner scanner = null;){
                    scanner = metaTable.getScanner(scan);
                    result = scanner.next();
                }
                if (result == null || result.isEmpty()) {
                    block36: {
                        Pair mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegionServerServices().getConnection(), (byte[])region.getRegionInfo().getRegionName());
                        if (mergeRegions == null || mergeRegions.getFirst() == null) {
                            StoreFile.Reader reader2 = reader;
                            return reader2;
                        }
                        byte[] splitRow = CellUtil.cloneRow((Cell)KeyValue.createKeyValueFromKey((byte[])r.getSplitKey()));
                        if (Bytes.compareTo((byte[])((HRegionInfo)mergeRegions.getFirst()).getStartKey(), (byte[])splitRow) == 0) {
                            if (((HRegionInfo)mergeRegions.getFirst()).getStartKey().length == 0 && region.getRegionInfo().getEndKey().length != ((HRegionInfo)mergeRegions.getFirst()).getEndKey().length) {
                                childRegion = (HRegionInfo)mergeRegions.getFirst();
                                regionStartKeyInHFile = ((HRegionInfo)mergeRegions.getFirst()).getStartKey().length == 0 ? new byte[((HRegionInfo)mergeRegions.getFirst()).getEndKey().length] : ((HRegionInfo)mergeRegions.getFirst()).getStartKey();
                                break block36;
                            } else {
                                StoreFile.Reader reader3 = reader;
                                return reader3;
                            }
                        }
                        childRegion = (HRegionInfo)mergeRegions.getSecond();
                        regionStartKeyInHFile = ((HRegionInfo)mergeRegions.getSecond()).getStartKey();
                    }
                    splitKey = KeyValue.createFirstOnRow((byte[])(region.getRegionInfo().getStartKey().length == 0 ? new byte[region.getRegionInfo().getEndKey().length] : region.getRegionInfo().getStartKey())).getKey();
                    break block37;
                }
                HRegionInfo parentRegion = HRegionInfo.getHRegionInfo((Result)result);
                regionStartKeyInHFile = parentRegion.getStartKey().length == 0 ? new byte[parentRegion.getEndKey().length] : parentRegion.getStartKey();
            }
        }
        try {
            conn = QueryUtil.getConnectionOnServer(((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataTable = IndexUtil.getPDataTable(conn, ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getRegion().getTableDesc());
            List<PTable> indexes = dataTable.getIndexes();
            HashMap<ImmutableBytesWritable, IndexMaintainer> indexMaintainers = new HashMap<ImmutableBytesWritable, IndexMaintainer>();
            for (PTable index : indexes) {
                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                IndexMaintainer indexMaintainer = index.getIndexMaintainer(dataTable, conn);
                indexMaintainers.put(new ImmutableBytesWritable(MetaDataUtil.getViewIndexIdDataType().toBytes(index.getViewIndexId())), indexMaintainer);
            }
            if (indexMaintainers.isEmpty()) {
                StoreFile.Reader i$ = reader;
                return i$;
            }
            byte[][] viewConstants = this.getViewConstants(dataTable);
            IndexHalfStoreFileReader indexHalfStoreFileReader = new IndexHalfStoreFileReader(fs, p, cacheConf, in, size, r, ((RegionCoprocessorEnvironment)ctx.getEnvironment()).getConfiguration(), indexMaintainers, viewConstants, childRegion, regionStartKeyInHFile, splitKey);
            return indexHalfStoreFileReader;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        }
    }

    public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s, CompactionRequest request) throws IOException {
        if (!IndexUtil.isLocalIndexStore(store)) {
            return s;
        }
        Scan scan = null;
        if (s != null) {
            scan = ((StoreScanner)s).scan;
        } else {
            scan = new Scan();
            scan.setMaxVersions(store.getFamily().getMaxVersions());
        }
        if (!store.hasReferences()) {
            InternalScanner repairScanner = null;
            if (request.isMajor() && !RepairUtil.isLocalIndexStoreFilesConsistent((RegionCoprocessorEnvironment)c.getEnvironment(), store)) {
                LOG.info((Object)("we have found inconsistent data for local index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo()));
                if (((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean(LOCAL_INDEX_AUTOMATIC_REPAIR, true)) {
                    LOG.info((Object)("Starting automatic repair of local Index for region:" + ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo()));
                    repairScanner = this.getRepairScanner((RegionCoprocessorEnvironment)c.getEnvironment(), store);
                }
            }
            if (repairScanner != null) {
                if (s != null) {
                    s.close();
                }
                return repairScanner;
            }
            return s;
        }
        ArrayList<StoreFileScanner> newScanners = new ArrayList<StoreFileScanner>(scanners.size());
        boolean scanUsePread = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean("hbase.storescanner.use.pread", scan.isSmall());
        for (KeyValueScanner keyValueScanner : scanners) {
            StoreFile.Reader reader = ((StoreFileScanner)keyValueScanner).getReader();
            if (reader instanceof IndexHalfStoreFileReader) {
                newScanners.add(new LocalIndexStoreFileScanner(reader, reader.getScanner(scan.getCacheBlocks(), scanUsePread, false), true, reader.getHFileReader().hasMVCCInfo(), store.getSmallestReadPoint(), keyValueScanner.getScannerOrder(), false));
                continue;
            }
            newScanners.add((StoreFileScanner)keyValueScanner);
        }
        if (s != null) {
            s.close();
        }
        return new StoreScanner(store, store.getScanInfo(), scan, newScanners, scanType, store.getSmallestReadPoint(), earliestPutTs);
    }

    private byte[][] getViewConstants(PTable dataTable) {
        int dataPosOffset = (dataTable.getBucketNum() != null ? 1 : 0) + (dataTable.isMultiTenant() ? 1 : 0);
        Object viewConstants = null;
        int nViewConstants = 0;
        if (dataTable.getType() == PTableType.VIEW) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            List<PColumn> dataPkColumns = dataTable.getPKColumns();
            for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                PColumn dataPKColumn = dataPkColumns.get(i);
                if (dataPKColumn.getViewConstant() == null) continue;
                ++nViewConstants;
            }
            if (nViewConstants > 0) {
                viewConstants = new byte[nViewConstants][];
                int j = 0;
                for (int i = dataPosOffset; i < dataPkColumns.size(); ++i) {
                    PColumn dataPkColumn = dataPkColumns.get(i);
                    if (dataPkColumn.getViewConstant() == null) continue;
                    if (IndexUtil.getViewConstantValue(dataPkColumn, ptr)) {
                        viewConstants[j++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
            }
        }
        return viewConstants;
    }

    private InternalScanner getRepairScanner(RegionCoprocessorEnvironment env, Store store) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions(store.getFamily().getMaxVersions());
        for (Store s : env.getRegion().getStores()) {
            if (IndexUtil.isLocalIndexStore(s)) continue;
            scan.addFamily(s.getFamily().getName());
        }
        try {
            PhoenixConnection conn = QueryUtil.getConnectionOnServer(env.getConfiguration()).unwrap(PhoenixConnection.class);
            PTable dataPTable = IndexUtil.getPDataTable(conn, env.getRegion().getTableDesc());
            ArrayList maintainers = Lists.newArrayListWithExpectedSize((int)dataPTable.getIndexes().size());
            for (PTable index : dataPTable.getIndexes()) {
                if (index.getIndexType() != PTable.IndexType.LOCAL) continue;
                maintainers.add(index.getIndexMaintainer(dataPTable, conn));
            }
            return new DataTableLocalIndexRegionScanner(env.getRegion().getScanner(scan), env.getRegion(), maintainers, store.getFamily().getName(), env.getConfiguration());
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new IOException(e);
        }
    }

    public KeyValueScanner preStoreScannerOpen(final ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
        if (store.getFamily().getNameAsString().startsWith("L#") && store.hasReferences()) {
            final long readPt = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getReadpoint(scan.getIsolationLevel());
            if (s != null) {
                s.close();
            }
            if (!scan.isReversed()) {
                return new StoreScanner(store, store.getScanInfo(), scan, targetCols, readPt){

                    protected List<KeyValueScanner> getScannersNoCompaction() throws IOException {
                        if (this.store.hasReferences()) {
                            return IndexHalfStoreFileReaderGenerator.this.getLocalIndexScanners((ObserverContext<RegionCoprocessorEnvironment>)c, this.store, this.scan, readPt);
                        }
                        return super.getScannersNoCompaction();
                    }
                };
            }
            return new ReversedStoreScanner(store, store.getScanInfo(), scan, targetCols, readPt){

                protected List<KeyValueScanner> getScannersNoCompaction() throws IOException {
                    if (this.store.hasReferences()) {
                        return IndexHalfStoreFileReaderGenerator.this.getLocalIndexScanners((ObserverContext<RegionCoprocessorEnvironment>)c, this.store, this.scan, readPt);
                    }
                    return super.getScannersNoCompaction();
                }
            };
        }
        return s;
    }

    private List<KeyValueScanner> getLocalIndexScanners(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, long readPt) throws IOException {
        int prefixLength;
        boolean scanUsePread = ((RegionCoprocessorEnvironment)c.getEnvironment()).getConfiguration().getBoolean("hbase.storescanner.use.pread", scan.isSmall());
        Collection storeFiles = store.getStorefiles();
        ArrayList<StoreFile> nonReferenceStoreFiles = new ArrayList<StoreFile>(store.getStorefiles().size());
        ArrayList<StoreFile> referenceStoreFiles = new ArrayList<StoreFile>(store.getStorefiles().size());
        ArrayList<KeyValueScanner> keyValueScanners = new ArrayList<KeyValueScanner>(store.getStorefiles().size() + 1);
        byte[] startKey = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getStartKey();
        byte[] endKey = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegionInfo().getEndKey();
        int n = scan.getAttribute("_ScanStartRowSuffix") == null ? (startKey.length == 0 ? endKey.length : startKey.length) : (prefixLength = scan.getStartRow().length - scan.getAttribute("_ScanStartRowSuffix").length);
        if (Bytes.compareTo((byte[])scan.getStartRow(), (int)0, (int)prefixLength, (byte[])(startKey.length == 0 ? new byte[endKey.length] : startKey), (int)0, (int)(startKey.length == 0 ? endKey.length : startKey.length)) != 0) {
            return keyValueScanners;
        }
        for (StoreFile storeFile : storeFiles) {
            if (storeFile.isReference()) {
                referenceStoreFiles.add(storeFile);
                continue;
            }
            nonReferenceStoreFiles.add(storeFile);
        }
        List scanners = StoreFileScanner.getScannersForStoreFiles(nonReferenceStoreFiles, (boolean)scan.getCacheBlocks(), (boolean)scanUsePread, (long)readPt);
        keyValueScanners.addAll(scanners);
        for (StoreFile sf : referenceStoreFiles) {
            long scannerOrder = 0L;
            if (sf.getReader() instanceof IndexHalfStoreFileReader) {
                keyValueScanners.add((KeyValueScanner)new LocalIndexStoreFileScanner(sf.getReader(), sf.getReader().getScanner(scan.getCacheBlocks(), scanUsePread, false), true, sf.getReader().getHFileReader().hasMVCCInfo(), readPt, scannerOrder++, false));
                continue;
            }
            keyValueScanners.add((KeyValueScanner)new StoreFileScanner(sf.getReader(), sf.getReader().getScanner(scan.getCacheBlocks(), scanUsePread, false), true, sf.getReader().getHFileReader().hasMVCCInfo(), readPt, scannerOrder++, false));
        }
        keyValueScanners.addAll(((HStore)store).memstore.getScanners(readPt));
        return keyValueScanners;
    }
}

