/*
 * Decompiled with CFR 0.152.
 */
package org.apache.omid.tools.hbase;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.omid.tools.hbase.SecureHBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HBaseLogin {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseLogin.class);
    private static volatile UserGroupInformation ugi;
    private static final Object KERBEROS_LOGIN_LOCK;

    @Nullable
    public static UserGroupInformation loginIfNeeded(SecureHBaseConfig config) throws IOException {
        return HBaseLogin.loginIfNeeded(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static UserGroupInformation loginIfNeeded(SecureHBaseConfig config, Configuration hbaseConf) throws IOException {
        boolean credsProvided;
        boolean bl = credsProvided = null != config.getPrincipal() && null != config.getKeytab();
        if (UserGroupInformation.isSecurityEnabled()) {
            boolean hasKerberosCreds;
            UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
            boolean bl2 = hasKerberosCreds = currentUser.hasKerberosCredentials() || currentUser.getRealUser() != null && currentUser.getRealUser().hasKerberosCredentials();
            if (!(!credsProvided || hasKerberosCreds && HBaseLogin.isSameName(currentUser.getUserName(), config.getPrincipal()))) {
                Object object = KERBEROS_LOGIN_LOCK;
                synchronized (object) {
                    currentUser = UserGroupInformation.getCurrentUser();
                    if (!hasKerberosCreds || !HBaseLogin.isSameName(currentUser.getUserName(), config.getPrincipal())) {
                        Configuration hbaseConfig = HBaseLogin.getConfiguration(hbaseConf, config.getPrincipal(), config.getKeytab());
                        LOG.info("Trying to connect to a secure cluster as {} with keytab {}", (Object)hbaseConfig.get("hbase.client.principal"), (Object)hbaseConfig.get("hbase.client.keytab"));
                        UserGroupInformation.setConfiguration((Configuration)hbaseConfig);
                        User.login((Configuration)hbaseConfig, (String)"hbase.client.keytab", (String)"hbase.client.principal", null);
                        LOG.info("Successful login to secure cluster");
                    }
                }
            } else if (hasKerberosCreds) {
                LOG.debug("Already logged in as {}", (Object)currentUser);
            } else {
                LOG.warn("Security enabled but not logged in, and did not provide credentials. NULL UGI returned");
            }
        }
        return ugi;
    }

    static boolean isSameName(String currentName, String newName, String hostname, String defaultRealm) throws IOException {
        boolean newNameContainsRealm;
        boolean bl = newNameContainsRealm = newName.indexOf(64) != -1;
        if (newName.contains("_HOST")) {
            if (newNameContainsRealm) {
                newName = SecurityUtil.getServerPrincipal((String)newName, (String)hostname);
            } else if (newName.endsWith("/_HOST")) {
                newName = newName.substring(0, newName.length() - 5) + hostname;
            }
        }
        if (!newNameContainsRealm && defaultRealm != null) {
            return currentName.equals(newName + "@" + defaultRealm);
        }
        return currentName.equals(newName);
    }

    static boolean isSameName(String currentName, String newName) throws IOException {
        return HBaseLogin.isSameName(currentName, newName, null, HBaseLogin.getDefaultKerberosRealm());
    }

    static String getDefaultKerberosRealm() {
        try {
            return KerberosUtil.getDefaultRealm();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Configuration getConfiguration(Configuration conf, String principal, String keytab) {
        if (conf == null) {
            conf = HBaseConfiguration.create();
        }
        if (null != principal) {
            conf.set("hbase.client.principal", principal);
        }
        if (null != keytab) {
            conf.set("hbase.client.keytab", keytab);
        }
        return conf;
    }

    static {
        KERBEROS_LOGIN_LOCK = new Object();
    }
}

