/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.xsd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.xsd.CapturingXMLEntityResolver;
import org.apache.ode.utils.xsd.XsdException;
import org.apache.ode.utils.xsd.XsdMessages;
import org.apache.xerces.dom.DOMInputImpl;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xs.XSModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.ls.LSInput;

public class XSUtils {
    private static final Logger __log = LoggerFactory.getLogger(XSUtils.class);
    private static final XsdMessages __msgs = MessageBundle.getMessages(XsdMessages.class);

    public static Map<URI, byte[]> captureSchema(URI uRI, byte[] byArray, XMLEntityResolver xMLEntityResolver, int n) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug("captureSchema(URI,Text,...): systemURI=" + uRI);
        }
        DOMInputImpl dOMInputImpl = new DOMInputImpl();
        dOMInputImpl.setSystemId(uRI.toString());
        dOMInputImpl.setByteStream((InputStream)new ByteArrayInputStream(byArray));
        Map<URI, byte[]> map = XSUtils.captureSchema((LSInput)dOMInputImpl, xMLEntityResolver);
        URI uRI2 = n == 0 ? uRI : URI.create(uRI.toString() + '.' + n);
        map.put(uRI2, byArray);
        return map;
    }

    private static Map<URI, byte[]> captureSchema(LSInput lSInput, XMLEntityResolver xMLEntityResolver) throws XsdException {
        if (__log.isDebugEnabled()) {
            __log.debug("captureSchema(LSInput,...): input.systemId=" + lSInput.getSystemId());
        }
        HashMap<URI, byte[]> hashMap = new HashMap<URI, byte[]>();
        if (xMLEntityResolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        CapturingXMLEntityResolver capturingXMLEntityResolver = new CapturingXMLEntityResolver(hashMap, xMLEntityResolver);
        XMLSchemaLoader xMLSchemaLoader = new XMLSchemaLoader();
        xMLSchemaLoader.setEntityResolver((XMLEntityResolver)capturingXMLEntityResolver);
        xMLSchemaLoader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
        LoggingXmlErrorHandler loggingXmlErrorHandler = new LoggingXmlErrorHandler(__log);
        xMLSchemaLoader.setErrorHandler((XMLErrorHandler)loggingXmlErrorHandler);
        LoggingDOMErrorHandler loggingDOMErrorHandler = new LoggingDOMErrorHandler(__log);
        xMLSchemaLoader.setParameter("error-handler", (Object)loggingDOMErrorHandler);
        XSModel xSModel = xMLSchemaLoader.load(lSInput);
        if (xSModel == null) {
            XMLParseException xMLParseException;
            Object object;
            XsdException xsdException = null;
            List<XMLParseException> list = loggingXmlErrorHandler.getErrors();
            if (list.size() != 0) {
                __log.error("captureSchema: XMLParseException(s) in " + lSInput);
                object = list.iterator();
                while (object.hasNext()) {
                    xMLParseException = (XMLParseException)object.next();
                    xsdException = new XsdException(xsdException, xMLParseException.getMessage(), xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getLiteralSystemId());
                }
            }
            if ((object = loggingDOMErrorHandler.getExceptions()).size() != 0) {
                xMLParseException = object.iterator();
                while (xMLParseException.hasNext()) {
                    Exception exception = (Exception)xMLParseException.next();
                    xsdException = new XsdException(xsdException, exception.getMessage());
                }
            }
            if (xsdException != null) {
                throw xsdException;
            }
            if (__log.isDebugEnabled()) {
                __log.debug("captureSchema: NULL model (unknown error) for " + lSInput.getSystemId());
            }
        }
        return hashMap;
    }

    static class LoggingDOMErrorHandler
    implements DOMErrorHandler {
        private ArrayList<Exception> _exceptions = new ArrayList();
        private Logger _log;

        public LoggingDOMErrorHandler(Logger logger) {
            assert (logger != null);
            this._log = logger;
        }

        @Override
        public boolean handleError(DOMError dOMError) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Exception occurred during parsing schema: " + dOMError.getMessage());
            }
            if (dOMError != null) {
                this._exceptions.add((Exception)dOMError.getRelatedException());
            }
            return false;
        }

        public ArrayList<Exception> getExceptions() {
            return this._exceptions;
        }
    }

    static class LoggingXmlErrorHandler
    implements XMLErrorHandler {
        private Logger _log;
        private ArrayList<XMLParseException> _errors = new ArrayList();

        public LoggingXmlErrorHandler(Logger logger) {
            assert (logger != null);
            this._log = logger;
        }

        public List<XMLParseException> getErrors() {
            return this._errors;
        }

        public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug("XSDErrorHandler.warning: domain=" + string + ", key=" + string2, (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
        }

        public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug("XSDErrorHandler.error: domain=" + string + ", key=" + string2, (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
            throw new XNIException("Unknown XSD error state; domain=" + string + ", key=" + string2);
        }

        public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
            if (this._log.isDebugEnabled()) {
                this._log.debug("XSDErrorHandler.fatal: domain=" + string + ", key=" + string2, (Throwable)xMLParseException);
            }
            if (xMLParseException != null) {
                this._errors.add(xMLParseException);
                throw xMLParseException;
            }
            throw new XNIException("Unknown XSD error state; domain=" + string + ", key=" + string2);
        }
    }
}

