/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.stl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ode.utils.stl.UnaryFunction;

public class FilterIterator<T>
implements Iterator<T> {
    private UnaryFunction<T, Boolean> _mf;
    private Iterator<T> _i;
    private T _next;

    public FilterIterator(Iterator<T> iterator, UnaryFunction<T, Boolean> unaryFunction) {
        this._i = iterator;
        this._mf = unaryFunction;
    }

    @Override
    public boolean hasNext() {
        return this.doNext();
    }

    @Override
    public T next() {
        if (this.doNext()) {
            T t = this._next;
            this._next = null;
            return t;
        }
        throw new NoSuchElementException("No more elements.");
    }

    @Override
    public void remove() {
        if (this.doNext()) {
            this._next = null;
            this._i.remove();
        }
        throw new NoSuchElementException("No more elements.");
    }

    private boolean doNext() {
        if (this._next != null) {
            return true;
        }
        while (this._i.hasNext()) {
            T t = this._i.next();
            if (this._mf.apply(t) != Boolean.TRUE) continue;
            this._next = t;
            return true;
        }
        return false;
    }
}

