/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.stl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.ode.utils.stl.UnaryFunctionEx;

public class CollectionsX {
    public static UnaryFunction<Map.Entry, Object> ufnMapEntry_getKey = new UnaryFunction<Map.Entry, Object>(){

        @Override
        public Object apply(Map.Entry entry) {
            return entry.getKey();
        }
    };
    public static UnaryFunction<Map.Entry, Object> ufnMapEntry_getValue = new UnaryFunction<Map.Entry, Object>(){

        @Override
        public Object apply(Map.Entry entry) {
            return entry.getValue();
        }
    };

    public static <T> void apply(Collection<T> collection, UnaryFunction<T, ?> unaryFunction) {
        CollectionsX.apply(collection.iterator(), unaryFunction);
    }

    public static <T> void apply(Iterator<T> iterator, UnaryFunction<T, ?> unaryFunction) {
        while (iterator.hasNext()) {
            unaryFunction.apply(iterator.next());
        }
    }

    public static <T> void apply(Collection<T> collection, UnaryFunctionEx<T, ?> unaryFunctionEx) throws Exception {
        CollectionsX.apply(collection.iterator(), unaryFunctionEx);
    }

    public static <T> void apply(Iterator<T> iterator, UnaryFunctionEx<T, ?> unaryFunctionEx) throws Exception {
        while (iterator.hasNext()) {
            unaryFunctionEx.apply(iterator.next());
        }
    }

    public static <T> T find_if(Collection<T> collection, MemberOfFunction<? super T> memberOfFunction) {
        return CollectionsX.find_if(collection.iterator(), memberOfFunction);
    }

    public static <T> T find_if(Iterator<T> iterator, MemberOfFunction<? super T> memberOfFunction) {
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!memberOfFunction.isMember(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> Collection<T> insert(Collection<T> collection, Enumeration<? extends T> enumeration) {
        while (enumeration.hasMoreElements()) {
            collection.add(enumeration.nextElement());
        }
        return collection;
    }

    public static <T> Collection<T> insert(Collection<T> collection, Iterator<? extends T> iterator) {
        while (iterator.hasNext()) {
            collection.add(iterator.next());
        }
        return collection;
    }

    public static <T> Collection<T> insert(Collection<T> collection, Collection<? extends T> collection2) {
        return CollectionsX.insert(collection, collection2.iterator());
    }

    public static <T> Collection<T> remove_if(Collection<T> collection, MemberOfFunction<T> memberOfFunction) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!memberOfFunction.isMember(iterator.next())) continue;
            iterator.remove();
        }
        return collection;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transform(C c, Collection<E> collection, UnaryFunction<E, V> unaryFunction) {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            c.add(unaryFunction.apply(iterator.next()));
        }
        return c;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transformEx(C c, Collection<E> collection, UnaryFunctionEx<E, V> unaryFunctionEx) throws Exception {
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            c.add(unaryFunctionEx.apply(iterator.next()));
        }
        return c;
    }

    public static <C extends Collection<T>, T, V extends T, E> C transform(C c, Enumeration<E> enumeration, UnaryFunction<E, V> unaryFunction) {
        while (enumeration.hasMoreElements()) {
            c.add(unaryFunction.apply(enumeration.nextElement()));
        }
        return c;
    }

    public static <C extends Collection<T>, T, S extends T> C filter(C c, Collection<S> collection, MemberOfFunction<S> memberOfFunction) {
        return CollectionsX.filter(c, collection.iterator(), memberOfFunction);
    }

    public static <C extends Collection<T>, T, S extends T> C filter(C c, Iterator<S> iterator, MemberOfFunction<S> memberOfFunction) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            if (!memberOfFunction.isMember(s)) continue;
            c.add(s);
        }
        return c;
    }

    public static <C extends Collection<T>, S, T extends S> C filter(C c, Collection<S> collection, Class<T> clazz) {
        return CollectionsX.filter(c, collection.iterator(), clazz);
    }

    public static <C extends Collection<T>, S, T extends S> C filter(C c, Iterator<S> iterator, Class<T> clazz) {
        while (iterator.hasNext()) {
            S s = iterator.next();
            if (!clazz.isAssignableFrom(s.getClass())) continue;
            c.add(s);
        }
        return c;
    }

    public static <T> Collection<T> filter(Collection collection, Class<T> clazz) {
        return CollectionsX.filter(new ArrayList(collection.size()), collection.iterator(), clazz);
    }
}

