/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.sax;

import java.io.PrintStream;
import org.apache.ode.utils.sax.IgnoreAllErrorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PrintErrorHandler
implements ErrorHandler {
    private ErrorHandler _child;
    private PrintStream _out;

    public PrintErrorHandler(ErrorHandler errorHandler, PrintStream printStream) {
        this._child = errorHandler;
        this._out = printStream;
    }

    public PrintErrorHandler(PrintStream printStream) {
        this(new IgnoreAllErrorHandler(), printStream);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this._out.println(this.formatMessage(sAXParseException));
        this._child.warning(sAXParseException);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this._out.println(this.formatMessage(sAXParseException));
        this._child.error(sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this._out.println(this.formatMessage(sAXParseException));
        this._child.fatalError(sAXParseException);
    }

    private String formatMessage(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        stringBuffer.append(sAXParseException.getSystemId());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        stringBuffer.append("] ");
        stringBuffer.append(sAXParseException.getMessage());
        return stringBuffer.toString();
    }
}

