/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.jmx;

import java.util.concurrent.atomic.AtomicLong;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.ode.utils.ObjectPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleMBean
extends StandardMBean
implements MBeanRegistration,
NotificationEmitter {
    private static final Logger __log = LoggerFactory.getLogger(SimpleMBean.class);
    protected MBeanServer _mbeanServer;
    protected ObjectName _myName;
    private MBeanNotificationInfo[] _infos = new MBeanNotificationInfo[0];
    private NotificationBroadcasterSupport _nbs = new NotificationBroadcasterSupport();
    private AtomicLong _notificationSequence = new AtomicLong(0L);

    public SimpleMBean(Class clazz) throws NotCompliantMBeanException {
        super(clazz);
        this.createMetaData(clazz);
    }

    private void createMetaData(Class clazz) {
    }

    @Override
    public void postDeregister() {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("postDeregister", new Object[0]));
        }
    }

    @Override
    public void postRegister(Boolean bl) {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("postRegister", new Object[]{"done", bl}));
        }
    }

    @Override
    public void preDeregister() throws Exception {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("preDeregister", new Object[0]));
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("preRegister", new Object[]{"mbeanServer", mBeanServer, "objectName", objectName}));
        }
        this._mbeanServer = mBeanServer;
        this._myName = objectName;
        return objectName;
    }

    public ObjectName register(MBeanServer mBeanServer) {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("register", new Object[]{"server", mBeanServer}));
        }
        try {
            mBeanServer.unregisterMBean(this.getObjectName());
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            __log.error("Error unregistering mbean: " + this.getObjectName().getCanonicalName(), (Throwable)mBeanRegistrationException);
        }
        try {
            mBeanServer.registerMBean(this, this.getObjectName());
        }
        catch (Exception exception) {
            __log.warn("Exception on register(): " + this.createObjectName());
        }
        return this.getObjectName();
    }

    public void unregister() {
        this.unregister(this._mbeanServer);
    }

    public void unregister(MBeanServer mBeanServer) {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("unregister", new Object[]{"server", mBeanServer}));
        }
        try {
            mBeanServer.unregisterMBean(this.getObjectName());
        }
        catch (Exception exception) {
            __log.warn("Exception on unregister(): " + this.getObjectName());
        }
    }

    protected abstract ObjectName createObjectName();

    public static ObjectName createObjectName(String string, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(':');
        for (int i = 0; i < stringArray.length / 2; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(stringArray[i * 2]);
            stringBuffer.append('=');
            stringBuffer.append(stringArray[i * 2 + 1].replace('=', '_').replace(',', '_').replace(':', '_'));
        }
        try {
            return new ObjectName(stringBuffer.toString());
        }
        catch (Exception exception) {
            String string2 = "DomainNodeImpl.createObjectName is broken!";
            __log.error(string2, (Throwable)exception);
            throw new AssertionError((Object)string2);
        }
    }

    public ObjectName getObjectName() {
        return this._myName == null ? this.createObjectName() : this._myName;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("addNotificationListener", new Object[]{"notificationListener", notificationListener, "notificationFilter", notificationFilter, "handback", object}));
        }
        this._nbs.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("removeNotificationListener", new Object[]{"notificationListener", notificationListener}));
        }
        this._nbs.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("removeNotificationListener", new Object[]{"notificationListener", notificationListener, "notificationFilter", notificationFilter, "handback", object}));
        }
        this._nbs.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this._infos;
    }

    protected void addNotificationInfo(MBeanNotificationInfo mBeanNotificationInfo) {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("send", new Object[]{"addNotificationInfo", mBeanNotificationInfo}));
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[this._infos.length + 1];
        System.arraycopy(this._infos, 0, mBeanNotificationInfoArray, 0, this._infos.length);
        mBeanNotificationInfoArray[mBeanNotificationInfoArray.length - 1] = mBeanNotificationInfo;
        this._infos = mBeanNotificationInfoArray;
    }

    protected void send(Notification notification) {
        if (__log.isTraceEnabled()) {
            __log.trace(ObjectPrinter.stringifyMethodEnter("send", new Object[]{"notification", notification}));
        }
        this._nbs.sendNotification(notification);
    }

    protected long nextNotificationSequence() {
        return this._notificationSequence.incrementAndGet();
    }
}

