/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.fs;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.SystemUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileManager {
    private static final Logger __log = LoggerFactory.getLogger(TempFileManager.class);
    private static TempFileManager __singleton;
    private static File __baseDir;
    private static File __workDir;
    private SortedSet<File> _registeredFiles = new TreeSet(Collections.reverseOrder(null));

    private static synchronized TempFileManager getInstance() {
        if (__singleton == null) {
            __singleton = new TempFileManager();
        }
        return __singleton;
    }

    private TempFileManager() {
        Object object;
        if (__baseDir == null) {
            object = null;
            try {
                object = SystemUtils.javaTemporaryDirectory();
            }
            catch (SecurityException securityException) {
                __log.error("Unable to read system property for temporary directory setting; will use default configuration.");
                object = "";
            }
            File file = new File((String)object);
            if (file.exists()) {
                __baseDir = file;
            } else {
                throw new IllegalStateException("Odd system configuration - temporary working directory " + (String)object + " does not exist.");
            }
        }
        try {
            object = new File(__baseDir, "ode-" + new GUID().toString());
            if (!((File)object).mkdir()) {
                throw new IllegalStateException("Unable to create temporary working directory in " + __baseDir.getPath());
            }
            __workDir = object;
            __log.debug("Set working directory to: " + __workDir.getAbsolutePath());
            this._registerTemporaryFile(__workDir);
        }
        catch (SecurityException securityException) {
            throw new IllegalStateException("The security configuration is preventing the creation of a temporary working directory.", securityException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void setWorkingDirectory(File file) {
        if (__singleton == null) {
            if (file == null) {
                __baseDir = null;
                return;
            } else {
                if (!file.isDirectory() || !file.canWrite()) throw new IllegalArgumentException("Not a writeable directory: " + file);
                __baseDir = file;
                __log.debug("Setting base working directory: " + file);
            }
            return;
        } else {
            String string = __baseDir != null ? "Already initialized in base directory: " + __baseDir.getPath() : "Already initialized, but no base directory set.";
            throw new IllegalStateException(string);
        }
    }

    public static synchronized File getTemporaryFile(String string) {
        return TempFileManager.getTemporaryFile(string, __workDir);
    }

    public static synchronized File getTemporaryFile(String string, File file) {
        File file2;
        if (__singleton == null) {
            TempFileManager.getInstance();
        }
        if (string == null) {
            string = "temp-";
        }
        if (file == null) {
            file = __workDir != null ? __workDir : __baseDir;
        }
        try {
            file2 = File.createTempFile(string + Long.toHexString(System.currentTimeMillis()), ".tmp", file);
        }
        catch (IOException iOException) {
            __log.error("Unable to create temporary file in working directory " + (file == null ? "<null>; " : file.getPath() + "; ") + "falling back to current working directory.", (Throwable)iOException);
            file2 = new File(string + new GUID().toString());
        }
        TempFileManager.registerTemporaryFile(file2);
        return file2;
    }

    public static synchronized File getTemporaryDirectory(String string) {
        return TempFileManager.getTemporaryDirectory(string, null);
    }

    public static synchronized File getTemporaryDirectory(String string, File file) {
        File file2 = TempFileManager.getTemporaryFile(string, file);
        file2.delete();
        file2.mkdirs();
        return file2;
    }

    public static synchronized void registerTemporaryFile(File file) {
        TempFileManager.getInstance()._registerTemporaryFile(file);
    }

    private synchronized void _registerTemporaryFile(File file) {
        this._registeredFiles.add(file);
        __log.debug("Registered temporary file: " + file.getPath());
    }

    public static synchronized void cleanup() {
        if (__singleton != null) {
            __singleton._cleanup();
            __singleton = null;
        } else {
            __log.debug("No cleanup necessary.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void _cleanup() {
        try {
            TreeSet treeSet = new TreeSet(Collections.reverseOrder(null));
            for (File file : this._registeredFiles) {
                if (!file.exists()) continue;
                treeSet.addAll(FileUtils.directoryEntriesInPath(file));
            }
            __log.debug("cleaning up " + treeSet.size() + " files.");
            for (File file : treeSet) {
                __log.debug("deleting: " + file.getAbsolutePath());
                if (!file.exists() || file.delete()) continue;
                __log.error("Unable to delete file " + file.getAbsolutePath() + "; this may be caused by a descriptor leak and should be reported.");
                file.deleteOnExit();
            }
        }
        finally {
            this._registeredFiles.clear();
            __workDir = null;
            __log.debug("cleanup done.");
        }
    }
}

