/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ode.utils.cli.CommandlineFragment;
import org.apache.ode.utils.cli.CommandlineSyntaxException;

public class XorGroup
implements CommandlineFragment {
    private List<CommandlineFragment> _frags = new ArrayList<CommandlineFragment>();
    private CommandlineFragment _matched;
    private boolean _isOptional;
    private String _description;

    public XorGroup(String string, boolean bl) {
        this._description = string;
        this._isOptional = bl;
    }

    @Override
    public void reset() {
        this._matched = null;
        Iterator<CommandlineFragment> iterator = this._frags.iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    public void addFragment(CommandlineFragment commandlineFragment) {
        this._frags.add(commandlineFragment);
    }

    public boolean didMatch() {
        return this._matched != null;
    }

    public CommandlineFragment getMatched() {
        return this._matched;
    }

    @Override
    public List<String> consume(List<String> list) throws CommandlineSyntaxException {
        List<String> list2 = null;
        for (CommandlineFragment commandlineFragment : this._frags) {
            try {
                list2 = commandlineFragment.consume(list);
            }
            catch (CommandlineSyntaxException commandlineSyntaxException) {
                continue;
            }
            if (this._matched == null) {
                this._matched = commandlineFragment;
                continue;
            }
            throw new CommandlineSyntaxException("Multiple possibilities matched from " + this.getUsage() + ".");
        }
        if (this._matched == null) {
            if (!this.isOptional()) {
                throw new CommandlineSyntaxException("No possibility matched from " + this.getUsage() + ".");
            }
            return new ArrayList<String>(list);
        }
        return list2;
    }

    @Override
    public String getUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<CommandlineFragment> iterator = this._frags.iterator();
        while (iterator.hasNext()) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append('|');
            }
            stringBuffer.append(iterator.next().getUsage());
        }
        return stringBuffer.toString();
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public boolean isOptional() {
        return this._isOptional;
    }
}

