/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URITemplate {
    private static final Logger log = LoggerFactory.getLogger(URITemplate.class);
    public static final String EXPANSION_REGEX = "\\{[^\\}]+\\}";
    private static final Pattern PATTERN = Pattern.compile("\\{[^\\}]+\\}");

    public static Object[] parseExpansion(String string) {
        String[] stringArray;
        String[] stringArray2;
        if (string.matches(EXPANSION_REGEX)) {
            string = string.substring(1, string.length() - 1);
        }
        if (string.contains("|")) {
            stringArray2 = string.split("\\|", -1);
            stringArray2[0] = stringArray2[0].substring(1);
        } else {
            stringArray2 = new String[]{null, null, string};
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : stringArray = stringArray2[2].split(",")) {
            if (string2.contains("=")) {
                String[] stringArray3 = string2.split("=");
                hashMap.put(stringArray3[0], stringArray3[1]);
                continue;
            }
            hashMap.put(string2, null);
        }
        return new Object[]{stringArray2[0], stringArray2[1], hashMap};
    }

    public static String expand(String string, String ... stringArray) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(string, URITemplate.toMap(stringArray));
    }

    public static String expand(String string, Map<String, String> map) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(string, map, false);
    }

    public static String expandLazily(String string, Map<String, String> map) throws URIException, UnsupportedOperationException {
        return URITemplate.expand(string, map, true);
    }

    public static String expandLazily(String string, String ... stringArray) throws URIException {
        return URITemplate.expandLazily(string, URITemplate.toMap(stringArray));
    }

    private static String expand(String string, Map<String, String> map, boolean bl) throws URIException, UnsupportedOperationException {
        Matcher matcher = PATTERN.matcher(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        while (matcher.find()) {
            stringBuilder.append(string.substring(n, matcher.start()));
            n = matcher.end();
            String string2 = string.substring(matcher.start(), matcher.end());
            Object[] objectArray = URITemplate.parseExpansion(string2);
            String string3 = (String)objectArray[0];
            if (string3 != null) {
                String string4 = "Operation not supported [" + string3 + "]. This expansion pattern [" + string2 + "] is not valid.";
                if (log.isWarnEnabled()) {
                    log.warn(string4);
                }
                throw new UnsupportedOperationException(string4);
            }
            stringBuilder.append(URITemplate.varSubstitution(string2, objectArray, map, bl));
        }
        if (stringBuilder.length() == 0) {
            return string;
        }
        stringBuilder.append(string.substring(n, string.length()));
        return stringBuilder.toString();
    }

    public static String varSubstitution(String string, Object[] objectArray, Map<String, String> map) throws URIException {
        return URITemplate.varSubstitution(string, objectArray, map, false);
    }

    public static String varSubstitution(String string, Object[] objectArray, Map<String, String> map, boolean bl) throws URIException {
        String string2;
        Map map2 = (Map)objectArray[2];
        Map.Entry entry = map2.entrySet().iterator().next();
        String string3 = (String)entry.getKey();
        String string4 = (String)entry.getValue();
        boolean bl2 = string4 != null;
        boolean bl3 = map.containsKey(string3);
        String string5 = map.get(string3);
        boolean bl4 = true;
        if (bl3) {
            string2 = string5 == null && !bl2 ? "" : (string5 != null ? string5 : string4);
        } else if (bl2) {
            string2 = string4;
        } else if (bl) {
            string2 = string;
            bl4 = false;
        } else {
            string2 = "";
        }
        return bl4 ? URIUtil.encodeWithinQuery((String)string2) : string2;
    }

    private static Map<String, String> toMap(String ... stringArray) {
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of elements is expected.");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        return hashMap;
    }
}

