/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ode.utils.DOMUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class SerializableElement
implements Serializable {
    private static final long serialVersionUID = -1L;
    private static final Logger __log = LoggerFactory.getLogger(SerializableElement.class);
    private transient Element e;

    public SerializableElement(Element element) {
        this.e = element;
    }

    public Element getElement() {
        return this.e;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            this.e = DOMUtils.stringToDOM((String)objectInputStream.readObject());
        }
        catch (SAXException sAXException) {
            __log.error("De-serialization eror", (Throwable)sAXException);
            throw new IOException(sAXException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(DOMUtils.domToString(this.e));
    }
}

