/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.apache.ode.utils.InternPool;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.CompositeUnaryFunction;
import org.apache.ode.utils.stl.EqualsUnaryFunction;
import org.apache.ode.utils.stl.FilterIterator;
import org.apache.ode.utils.stl.TransformIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSContext
implements NamespaceContext,
Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger __log = LoggerFactory.getLogger(NSContext.class);
    private HashMap<String, String> _prefixToUriMap = new HashMap<String, String>(){

        @Override
        public String put(String string, String string2) {
            string = (String)InternPool.intern("namespace.prefixes", string);
            string2 = (String)InternPool.intern("namespace.uris", string2);
            return super.put(string, string2);
        }
    };

    public NSContext() {
    }

    public NSContext(NSContext nSContext) {
        this._prefixToUriMap.putAll(nSContext._prefixToUriMap);
    }

    @Override
    public String getNamespaceURI(String string) {
        return this._prefixToUriMap.get(string == null ? "" : string);
    }

    @Override
    public String getPrefix(String string) {
        Iterator iterator = this.getPrefixes(string);
        if (iterator.hasNext()) {
            return (String)iterator.next();
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        return new TransformIterator<Map.Entry, Object>(new FilterIterator<Map.Entry<String, String>>(this._prefixToUriMap.entrySet().iterator(), new CompositeUnaryFunction(new EqualsUnaryFunction<String>(string), CollectionsX.ufnMapEntry_getValue)), CollectionsX.ufnMapEntry_getKey);
    }

    public Set<String> getPrefixes() {
        return Collections.unmodifiableSet(this._prefixToUriMap.keySet());
    }

    public Set<String> getUriSet() {
        return new HashSet<String>(this._prefixToUriMap.values());
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        for (int i = 0; i < n; ++i) {
            String string = objectInput.readUTF();
            String string2 = objectInput.readUTF();
            this._prefixToUriMap.put(string, string2);
        }
        if (__log.isTraceEnabled()) {
            __log.trace("readExternal: contents=" + this._prefixToUriMap);
        }
    }

    public void register(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        if (string == null) {
            string = "";
        }
        if (__log.isTraceEnabled()) {
            __log.trace("register(prefix=" + string + ", uri=" + string2 + ")");
        }
        this._prefixToUriMap.put(string, string2);
    }

    public void register(Map<String, String> map) {
        if (__log.isTraceEnabled()) {
            __log.trace("register(prefixmappings=" + map + ")");
        }
        this._prefixToUriMap.putAll(map);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (__log.isTraceEnabled()) {
            __log.trace("writeExternal: contents=" + this._prefixToUriMap);
        }
        objectOutput.writeInt(this._prefixToUriMap.size());
        for (Map.Entry<String, String> entry : this._prefixToUriMap.entrySet()) {
            objectOutput.writeUTF(entry.getKey());
            objectOutput.writeUTF(entry.getValue());
        }
    }

    public QName derefQName(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(58);
        if (n == -1) {
            return new QName(this.getNamespaceURI(null), string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = this.getNamespaceURI(string2);
        if (string4 == null) {
            return null;
        }
        return new QName(string4, string3);
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this._prefixToUriMap);
    }
}

