/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.slf4j.Logger;

public class LoggingInterceptor<T>
implements InvocationHandler {
    private static final Set<String> PARAMSTYPES = new HashSet<String>();
    private Logger _log;
    private T _delegate;
    private Map<String, Object> _paramsByName = new TreeMap<String, Object>();
    private Map<Integer, Object> _paramsByIdx = new TreeMap<Integer, Object>();

    public LoggingInterceptor(T t, Logger logger) {
        this._log = logger;
        this._delegate = t;
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        try {
            if (method.getDeclaringClass() == DataSource.class && "getConnection".equals(method.getName())) {
                Connection connection = (Connection)method.invoke(this._delegate, objectArray);
                this.print("getConnection (tx=" + connection.getTransactionIsolation() + ")");
                return Proxy.newProxyInstance(this._delegate.getClass().getClassLoader(), new Class[]{Connection.class}, new LoggingInterceptor<Connection>(connection, this._log));
            }
            if (method.getDeclaringClass() == Connection.class && Statement.class.isAssignableFrom(method.getReturnType())) {
                Statement statement = (Statement)method.invoke(this._delegate, objectArray);
                this.print(method, objectArray);
                return Proxy.newProxyInstance(this._delegate.getClass().getClassLoader(), new Class[]{method.getReturnType()}, new LoggingInterceptor<Statement>(statement, this._log));
            }
            this.print(method, objectArray);
            return method.invoke(this._delegate, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    private void print(Method method, Object[] objectArray) {
        if (this.shouldPrint()) {
            if ("prepareStatement".equals(method.getName())) {
                this.print("prepareStatement: " + objectArray[0]);
            } else if ("prepareCall".equals(method.getName())) {
                this.print("prepareCall: " + objectArray[0]);
            } else if ("close".equals(method.getName())) {
                this.print("close()");
            } else if ("commit".equals(method.getName())) {
                this.print("commit()");
            } else if ("rollback".equals(method.getName())) {
                this.print("rollback()");
            } else if ("setTransactionIsolation".equals(method.getName())) {
                this.print("Set isolation level to " + objectArray[0]);
            } else if (method.getName().startsWith("execute")) {
                this.print(method.getName() + ", " + this.getParams());
            } else if ("clearParameters".equals(method.getName())) {
                this._paramsByIdx.clear();
                this._paramsByName.clear();
            } else if ("setNull".equals(method.getName())) {
                if (String.class.isAssignableFrom(objectArray[0].getClass())) {
                    this._paramsByName.put((String)objectArray[0], null);
                } else if (Integer.class.isAssignableFrom(objectArray[0].getClass())) {
                    this._paramsByIdx.put((Integer)objectArray[0], null);
                }
            } else if (PARAMSTYPES.contains(method.getName())) {
                if (String.class.isAssignableFrom(objectArray[0].getClass())) {
                    this._paramsByName.put((String)objectArray[0], objectArray[1]);
                } else if (Integer.class.isAssignableFrom(objectArray[0].getClass())) {
                    this._paramsByIdx.put((Integer)objectArray[0], objectArray[1]);
                }
            }
        }
    }

    private String getParams() {
        if (this._paramsByIdx.size() > 0 || this._paramsByName.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("bound ");
            for (Map.Entry<Integer, Object> entry : this._paramsByIdx.entrySet()) {
                try {
                    stringBuffer.append("(").append(entry.getKey()).append(",").append(entry.getValue()).append(") ");
                }
                catch (Throwable throwable) {
                    return "[e]";
                }
            }
            for (Map.Entry<Object, Object> entry : this._paramsByName.entrySet()) {
                try {
                    stringBuffer.append("(").append((String)entry.getKey()).append(",").append(entry.getValue()).append(") ");
                }
                catch (Throwable throwable) {
                    return "[e]";
                }
            }
            return stringBuffer.toString();
        }
        return "w/o params";
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String string) {
        if (this._log != null) {
            this._log.debug(string);
        } else {
            System.out.println(string);
        }
    }

    public static DataSource createLoggingDS(DataSource dataSource, Logger logger) {
        return (DataSource)Proxy.newProxyInstance(dataSource.getClass().getClassLoader(), new Class[]{DataSource.class}, new LoggingInterceptor<DataSource>(dataSource, logger));
    }

    static {
        PARAMSTYPES.add("setArray");
        PARAMSTYPES.add("setBigDecimal");
        PARAMSTYPES.add("setBoolean");
        PARAMSTYPES.add("setByte");
        PARAMSTYPES.add("setBytes");
        PARAMSTYPES.add("setDate");
        PARAMSTYPES.add("setDouble");
        PARAMSTYPES.add("setFloat");
        PARAMSTYPES.add("setInt");
        PARAMSTYPES.add("setLong");
        PARAMSTYPES.add("setObject");
        PARAMSTYPES.add("setRef");
        PARAMSTYPES.add("setShort");
        PARAMSTYPES.add("setString");
        PARAMSTYPES.add("setTime");
        PARAMSTYPES.add("setTimestamp");
        PARAMSTYPES.add("setURL");
    }
}

