/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class ISO8601DateParser {
    public static Date parse(String string) throws ParseException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string.trim());
        boolean bl = false;
        switch (stringBuffer.length()) {
            case 4: {
                string2 = "yyyy";
                break;
            }
            case 7: {
                string2 = "yyyy-MM";
                break;
            }
            case 10: {
                string2 = "yyyy-MM-dd";
                break;
            }
            default: {
                string2 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                if (stringBuffer.length() == 16) {
                    stringBuffer.append(":00");
                }
                if (stringBuffer.length() > 16 && stringBuffer.charAt(16) != ':') {
                    stringBuffer.insert(16, ":00");
                }
                if (stringBuffer.length() == 19) {
                    stringBuffer.append(".000");
                }
                if (stringBuffer.length() > 19 && stringBuffer.charAt(19) != '.') {
                    stringBuffer.insert(19, ".000");
                }
                if (stringBuffer.charAt(19) == '.' && (stringBuffer.length() < 22 || stringBuffer.lastIndexOf("-") < 23 && stringBuffer.lastIndexOf("-") > 19 || stringBuffer.lastIndexOf("+") < 23 && stringBuffer.lastIndexOf("+") > 0)) {
                    stringBuffer.insert(20, "0");
                }
                if (stringBuffer.charAt(19) == '.' && (stringBuffer.length() < 22 || stringBuffer.lastIndexOf("-") < 23 && stringBuffer.lastIndexOf("-") > 19 || stringBuffer.lastIndexOf("+") < 23 && stringBuffer.lastIndexOf("+") > 0)) {
                    stringBuffer.insert(20, "0");
                }
                if (stringBuffer.length() > 23) {
                    string2 = string2 + "Z";
                    bl = true;
                }
                if (stringBuffer.length() == 24 && stringBuffer.charAt(23) == 'Z') {
                    stringBuffer.replace(23, 24, "+0000");
                }
                if (stringBuffer.length() != 29 || stringBuffer.charAt(26) != ':') break;
                stringBuffer.deleteCharAt(26);
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        if (bl) {
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        return simpleDateFormat.parse(stringBuffer.toString());
    }

    public static Calendar parseCal(String string) throws ParseException {
        Date date = ISO8601DateParser.parse(string);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static String format(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        boolean bl = TimeZone.getTimeZone("UTC").equals(timeZone) || TimeZone.getTimeZone("GMT").equals(timeZone);
        String string = bl ? "yyyy-MM-dd'T'HH:mm:ss'Z'" : "yyyy-MM-dd'T'HH:mm:ssZ";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        simpleDateFormat.setTimeZone(timeZone);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date));
        if (!bl) {
            stringBuffer.insert(stringBuffer.length() - 2, ':');
        }
        return stringBuffer.toString();
    }
}

