/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbIsolation {
    private static final Logger __log = LoggerFactory.getLogger(DbIsolation.class);
    private static int _isolationLevel;

    public static int getOdeIsolationLevel() {
        return _isolationLevel;
    }

    public static void setOdeIsolationLevel(int n) {
        _isolationLevel = n;
    }

    public static void setIsolationLevel(Connection connection) throws SQLException {
        block4: {
            try {
                if (_isolationLevel != 0 && connection.getTransactionIsolation() != _isolationLevel) {
                    if (__log.isDebugEnabled()) {
                        __log.debug("Set isolation level to " + _isolationLevel);
                    }
                    connection.setTransactionIsolation(_isolationLevel);
                }
            }
            catch (Exception exception) {
                if (!__log.isDebugEnabled()) break block4;
                __log.debug("Error while setting isolation level to " + _isolationLevel, (Throwable)exception);
            }
        }
    }

    static {
        try {
            _isolationLevel = Integer.parseInt(System.getProperty("ode.connection.isolation", "2"));
        }
        catch (Throwable throwable) {
            __log.error("Error while reading 'ode.connnection.isolation' property", throwable);
        }
    }
}

