/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.vpu;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.IndexedObject;
import org.apache.ode.jacob.JacobObject;
import org.apache.ode.jacob.soup.Comm;
import org.apache.ode.jacob.soup.CommChannel;
import org.apache.ode.jacob.soup.CommGroup;
import org.apache.ode.jacob.soup.CommRecv;
import org.apache.ode.jacob.soup.CommSend;
import org.apache.ode.jacob.soup.Continuation;
import org.apache.ode.jacob.soup.ExecutionQueue;
import org.apache.ode.jacob.soup.ExecutionQueueObject;
import org.apache.ode.jacob.soup.ReplacementMap;
import org.apache.ode.jacob.vpu.ChannelFactory;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.ObjectPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionQueueImpl
implements ExecutionQueue {
    private static final Log __log = LogFactory.getLog(ExecutionQueueImpl.class);
    private ClassLoader _classLoader;
    private static ConcurrentHashMap<String, ObjectStreamClass> _classDescriptors = new ConcurrentHashMap();
    private Set<Continuation> _reactions = new HashSet<Continuation>();
    private Map<Integer, ChannelFrame> _channels = new HashMap<Integer, ChannelFrame>();
    private int _currentCycle;
    private int _objIdCounter;
    private ExecutionQueueStatistics _statistics = new ExecutionQueueStatistics();
    private ReplacementMap _replacementMap;
    private Serializable _gdata;
    private Map<Object, LinkedList<IndexedObject>> _index = new HashMap<Object, LinkedList<IndexedObject>>();

    public ExecutionQueueImpl(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    @Override
    public void setReplacementMap(ReplacementMap replacementMap) {
        this._replacementMap = replacementMap;
    }

    public Map<Object, LinkedList<IndexedObject>> getIndex() {
        return this._index;
    }

    @Override
    public void add(CommChannel commChannel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"add", (Object[])new Object[]{"channel", commChannel}));
        }
        this.verifyNew(commChannel);
        ChannelFrame channelFrame = new ChannelFrame(commChannel.getType(), ++this._objIdCounter, commChannel.getType().getName(), commChannel.getDescription());
        this._channels.put(channelFrame.getId(), channelFrame);
        this.assignId(commChannel, channelFrame.getId());
    }

    @Override
    public void enqueueReaction(Continuation continuation) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"enqueueReaction", (Object[])new Object[]{"continuation", continuation}));
        }
        this.verifyNew(continuation);
        this._reactions.add(continuation);
    }

    @Override
    public Continuation dequeueReaction() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"dequeueReaction", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        Continuation continuation = null;
        if (!this._reactions.isEmpty()) {
            Iterator<Continuation> iterator = this._reactions.iterator();
            continuation = iterator.next();
            iterator.remove();
        }
        return continuation;
    }

    @Override
    public void add(CommGroup commGroup) {
        Comm comm;
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"add", (Object[])new Object[]{"group", commGroup}));
        }
        this.verifyNew(commGroup);
        CommGroupFrame commGroupFrame = new CommGroupFrame(commGroup.isReplicated());
        Iterator<Comm> iterator = commGroup.getElements();
        while (iterator.hasNext()) {
            CommFrame commFrame;
            Comm comm2;
            comm = iterator.next();
            ChannelFrame channelFrame = this.findChannelFrame(comm.getChannel().getId());
            if (comm instanceof CommSend) {
                if (channelFrame.replicatedSend) {
                    throw new IllegalStateException("Send attempted on channel containing replicated send! Channel= " + comm.getChannel());
                }
                if (commGroup.isReplicated()) {
                    channelFrame.replicatedSend = true;
                }
                comm2 = (CommSend)comm;
                commFrame = new MessageFrame(commGroupFrame, channelFrame, ((CommSend)comm2).getMethod().getName(), ((CommSend)comm2).getArgs());
                commGroupFrame.commFrames.add(commFrame);
                channelFrame.msgFrames.add((MessageFrame)commFrame);
                continue;
            }
            if (!(comm instanceof CommRecv)) continue;
            if (channelFrame.replicatedRecv) {
                throw new IllegalStateException("Receive attempted on channel containing replicated receive! Channel= " + comm.getChannel());
            }
            if (commGroup.isReplicated()) {
                channelFrame.replicatedRecv = true;
            }
            comm2 = (CommRecv)comm;
            commFrame = new ObjectFrame(commGroupFrame, channelFrame, ((CommRecv)comm2).getContinuation());
            commGroupFrame.commFrames.add(commFrame);
            channelFrame.objFrames.add((ObjectFrame)commFrame);
        }
        iterator = commGroup.getElements();
        while (iterator.hasNext()) {
            comm = iterator.next();
            this.matchCommunications(comm.getChannel());
        }
    }

    private ChannelFrame findChannelFrame(Object object) {
        ChannelFrame channelFrame = this._channels.get(object);
        if (channelFrame == null) {
            throw new IllegalArgumentException("No such channel; id=" + object);
        }
        return channelFrame;
    }

    @Override
    public int cycle() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"cycle", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
        return ++this._currentCycle;
    }

    @Override
    public String createExport(CommChannel commChannel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"createExport", (Object[])new Object[]{"channel", commChannel}));
        }
        ChannelFrame channelFrame = this.findChannelFrame(commChannel.getId());
        ++channelFrame.refCount;
        return commChannel.getId().toString();
    }

    @Override
    public CommChannel consumeExport(String string) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"consumeExport", (Object[])new Object[]{"exportId", string}));
        }
        Integer n = Integer.valueOf(string);
        ChannelFrame channelFrame = this.findChannelFrame(n);
        --channelFrame.refCount;
        CommChannel commChannel = new CommChannel(channelFrame.type);
        commChannel.setId(n);
        commChannel.setDescription("EXPORTED CHANNEL");
        return commChannel;
    }

    @Override
    public boolean hasReactions() {
        return !this._reactions.isEmpty();
    }

    @Override
    public void flush() {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"flush", (Object[])CollectionUtils.EMPTY_OBJECT_ARRAY));
        }
    }

    public void read(InputStream inputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        int n3;
        this._channels.clear();
        this._reactions.clear();
        this._index.clear();
        ExecutionQueueInputStream executionQueueInputStream = new ExecutionQueueInputStream(inputStream);
        this._objIdCounter = executionQueueInputStream.readInt();
        this._currentCycle = executionQueueInputStream.readInt();
        int n4 = executionQueueInputStream.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            JacobObject jacobObject = (JacobObject)executionQueueInputStream.readObject();
            String string = executionQueueInputStream.readUTF();
            Method method = jacobObject.getMethod(string);
            n2 = executionQueueInputStream.readInt();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = executionQueueInputStream.readObject();
            }
            this._reactions.add(new Continuation(jacobObject, method, objectArray));
        }
        n3 = executionQueueInputStream.readInt();
        for (n = 0; n < n3; ++n) {
            int n5;
            int n6 = executionQueueInputStream.readInt();
            for (n5 = 0; n5 < n6; ++n5) {
                executionQueueInputStream.readObject();
            }
            n5 = executionQueueInputStream.readInt();
            for (n2 = 0; n2 < n5; ++n2) {
                executionQueueInputStream.readObject();
            }
        }
        n3 = executionQueueInputStream.readInt();
        for (n = 0; n < n3; ++n) {
            ChannelFrame channelFrame = (ChannelFrame)executionQueueInputStream.readObject();
            this._channels.put(channelFrame.getId(), channelFrame);
        }
        this._gdata = (Serializable)executionQueueInputStream.readObject();
        executionQueueInputStream.close();
    }

    private void index(IndexedObject indexedObject) {
        LinkedList<IndexedObject> linkedList = this._index.get(indexedObject.getKey());
        if (linkedList == null) {
            linkedList = new LinkedList();
            this._index.put(indexedObject.getKey(), linkedList);
        }
        linkedList.add(indexedObject);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.flush();
        ExecutionQueueOutputStream executionQueueOutputStream = new ExecutionQueueOutputStream(outputStream);
        executionQueueOutputStream.writeInt(this._objIdCounter);
        executionQueueOutputStream.writeInt(this._currentCycle);
        executionQueueOutputStream.writeInt(this._reactions.size());
        for (Continuation iterator2 : this._reactions) {
            executionQueueOutputStream.writeObject(iterator2.getClosure());
            executionQueueOutputStream.writeUTF(iterator2.getMethod().getName());
            executionQueueOutputStream.writeInt(iterator2.getArgs() == null ? 0 : iterator2.getArgs().length);
            for (int channelFrame = 0; iterator2.getArgs() != null && channelFrame < iterator2.getArgs().length; ++channelFrame) {
                executionQueueOutputStream.writeObject(iterator2.getArgs()[channelFrame]);
            }
        }
        executionQueueOutputStream.writeInt(this._channels.values().size());
        for (ChannelFrame channelFrame : this._channels.values()) {
            executionQueueOutputStream.writeInt(channelFrame.objFrames.size());
            Iterator<CommFrame> iterator = channelFrame.objFrames.iterator();
            while (iterator.hasNext()) {
                executionQueueOutputStream.writeObject(iterator.next());
            }
            executionQueueOutputStream.writeInt(channelFrame.msgFrames.size());
            iterator = channelFrame.msgFrames.iterator();
            while (iterator.hasNext()) {
                executionQueueOutputStream.writeObject(iterator.next());
            }
        }
        Set<Object> set = executionQueueOutputStream.getSerializedChannels();
        Iterator<ChannelFrame> iterator = this._channels.values().iterator();
        while (iterator.hasNext()) {
            ChannelFrame channelFrame = iterator.next();
            if (set.contains(channelFrame.id) || channelFrame.refCount > 0) continue;
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("GC Channel: " + channelFrame));
            }
            iterator.remove();
        }
        executionQueueOutputStream.writeInt(this._channels.values().size());
        for (ChannelFrame channelFrame : this._channels.values()) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Writing Channel: " + channelFrame));
            }
            executionQueueOutputStream.writeObject(channelFrame);
        }
        executionQueueOutputStream.writeObject(this._gdata);
        executionQueueOutputStream.close();
    }

    @Override
    public boolean isComplete() {
        if (!this._reactions.isEmpty()) {
            return false;
        }
        Iterator<ChannelFrame> iterator = this._channels.values().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().refCount <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dumpState(PrintStream printStream) {
        printStream.print(this.toString());
        printStream.println(" state dump:");
        printStream.println("-- GENERAL INFO");
        printStream.println("   Current Cycle          : " + this._currentCycle);
        printStream.println("   Num. Reactions  : " + this._reactions.size());
        this._statistics.printStatistics(printStream);
        if (!this._reactions.isEmpty()) {
            printStream.println("-- REACTIONS");
            int n = 0;
            for (Continuation continuation : this._reactions) {
                printStream.println("   #" + ++n + ":  " + continuation.toString());
            }
        }
    }

    private void matchCommunications(CommChannel commChannel) {
        if (__log.isTraceEnabled()) {
            __log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"matchCommunications", (Object[])new Object[]{"channel", commChannel}));
        }
        ChannelFrame channelFrame = this._channels.get(commChannel.getId());
        while (channelFrame != null && !channelFrame.msgFrames.isEmpty() && !channelFrame.objFrames.isEmpty()) {
            MessageFrame messageFrame = channelFrame.msgFrames.iterator().next();
            ObjectFrame objectFrame = channelFrame.objFrames.iterator().next();
            Continuation continuation = new Continuation(objectFrame._continuation, objectFrame._continuation.getMethod(messageFrame.method), messageFrame.args);
            if (__log.isInfoEnabled()) {
                continuation.setDescription(commChannel + " ? {...} | " + commChannel + " ! " + messageFrame.method + "(...)");
            }
            this.enqueueReaction(continuation);
            if (!messageFrame.commGroupFrame.replicated) {
                this.removeCommGroup(messageFrame.commGroupFrame);
            }
            if (objectFrame.commGroupFrame.replicated) continue;
            this.removeCommGroup(objectFrame.commGroupFrame);
        }
    }

    private void verifyNew(ExecutionQueueObject executionQueueObject) throws IllegalArgumentException {
        if (executionQueueObject.getId() != null) {
            throw new IllegalArgumentException("The object " + executionQueueObject + " is not new!");
        }
    }

    private void assignId(ExecutionQueueObject executionQueueObject, Object object) {
        executionQueueObject.setId(object);
    }

    private void removeCommGroup(CommGroupFrame commGroupFrame) {
        for (CommFrame commFrame : commGroupFrame.commFrames) {
            if (commFrame instanceof ObjectFrame) {
                assert (commFrame.channelFrame.objFrames.contains(commFrame));
                commFrame.channelFrame.objFrames.remove(commFrame);
                continue;
            }
            assert (commFrame instanceof MessageFrame);
            assert (commFrame.channelFrame.msgFrames.contains(commFrame));
            commFrame.channelFrame.msgFrames.remove(commFrame);
        }
    }

    public void setGlobalData(Serializable serializable) {
        this._gdata = serializable;
    }

    public Serializable getGlobalData() {
        return this._gdata;
    }

    private static final class ExecutionQueueStatistics {
        public long cloneClosureTimeMs;
        public long cloneClosureBytes;
        public long cloneClousreCount;
        public long cloneClosureReadTimeMs;

        private ExecutionQueueStatistics() {
        }

        public void printStatistics(PrintStream printStream) {
            Field[] fieldArray = this.getClass().getFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                printStream.print(fieldArray[i].getName());
                printStream.print(" = ");
                try {
                    printStream.println(fieldArray[i].get(this));
                    continue;
                }
                catch (Exception exception) {
                    printStream.println(exception.toString());
                }
            }
        }
    }

    private static final class ChannelRef
    implements Externalizable {
        private Class _type;
        private Integer _id;

        private ChannelRef(Class clazz, Integer n) {
            this._type = clazz;
            this._id = n;
        }

        public ChannelRef() {
        }

        public boolean equals(Object object) {
            return ((ChannelRef)object)._id.equals(this._id);
        }

        public int hashCode() {
            return this._id.hashCode();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this._type);
            objectOutput.writeInt(this._id);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this._type = (Class)objectInput.readObject();
            this._id = objectInput.readInt();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExecutionQueueInputStream
    extends ObjectInputStream {
        private Set<CommChannel> _deserializedChannels;

        public ExecutionQueueInputStream(InputStream inputStream) throws IOException {
            super(new GZIPInputStream(inputStream));
            this._deserializedChannels = new HashSet<CommChannel>();
            this.enableResolveObject(true);
        }

        public Set<CommChannel> getSerializedChannels() {
            return this._deserializedChannels;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            return Class.forName(objectStreamClass.getName(), true, ExecutionQueueImpl.this._classLoader);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            boolean bl = this.readBoolean();
            if (bl) {
                String string = this.readUTF();
                ObjectStreamClass objectStreamClass = (ObjectStreamClass)_classDescriptors.get(string);
                if (objectStreamClass == null) {
                    objectStreamClass = ObjectStreamClass.lookup(Class.forName(string, true, ExecutionQueueImpl.this._classLoader));
                    _classDescriptors.put(string, objectStreamClass);
                }
                return objectStreamClass;
            }
            return super.readClassDescriptor();
        }

        @Override
        protected Object resolveObject(Object object) throws IOException {
            Object object2;
            if (object instanceof ChannelRef) {
                ChannelRef channelRef = (ChannelRef)object;
                CommChannel commChannel = new CommChannel(channelRef._type);
                commChannel.setId(channelRef._id);
                this._deserializedChannels.add(commChannel);
                object2 = ChannelFactory.createChannel(commChannel, commChannel.getType());
            } else if (ExecutionQueueImpl.this._replacementMap != null && ExecutionQueueImpl.this._replacementMap.isReplacement(object)) {
                object2 = ExecutionQueueImpl.this._replacementMap.getOriginal(object);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ReplacementMap: getOriginal(" + object + ") = " + object2));
                }
            } else {
                object2 = object;
            }
            if (object2 != null && object2 instanceof IndexedObject) {
                ExecutionQueueImpl.this.index((IndexedObject)object2);
            }
            return object2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExecutionQueueOutputStream
    extends ObjectOutputStream {
        private Set<Object> _serializedChannels;

        public ExecutionQueueOutputStream(OutputStream outputStream) throws IOException {
            super(new GZIPOutputStream(outputStream));
            this._serializedChannels = new HashSet<Object>();
            this.enableReplaceObject(true);
        }

        public Set<Object> getSerializedChannels() {
            return this._serializedChannels;
        }

        @Override
        protected void writeClassDescriptor(ObjectStreamClass objectStreamClass) throws IOException {
            if (Serializable.class.isAssignableFrom(objectStreamClass.forClass())) {
                this.writeBoolean(true);
                this.writeUTF(objectStreamClass.getName());
            } else {
                this.writeBoolean(false);
                super.writeClassDescriptor(objectStreamClass);
            }
        }

        @Override
        protected Object replaceObject(Object object) throws IOException {
            if (!Serializable.class.isAssignableFrom(object.getClass())) {
                return null;
            }
            if (object instanceof Channel) {
                CommChannel commChannel = (CommChannel)ChannelFactory.getBackend((Channel)object);
                this._serializedChannels.add(commChannel.getId());
                return new ChannelRef(commChannel.getType(), (Integer)commChannel.getId());
            }
            if (ExecutionQueueImpl.this._replacementMap != null && ExecutionQueueImpl.this._replacementMap.isReplaceable(object)) {
                Object object2 = ExecutionQueueImpl.this._replacementMap.getReplacement(object);
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("ReplacmentMap: getReplacement(" + object + ") = " + object2));
                }
                return object2;
            }
            return object;
        }
    }

    private static class MessageFrame
    extends CommFrame
    implements Externalizable {
        private static final long serialVersionUID = -1112437852498126297L;
        String method;
        Object[] args;

        public MessageFrame() {
        }

        public MessageFrame(CommGroupFrame commGroupFrame, ChannelFrame channelFrame, String string, Object[] objectArray) {
            super(commGroupFrame, channelFrame);
            this.method = string;
            this.args = objectArray == null ? CollectionUtils.EMPTY_CLASS_ARRAY : objectArray;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this.method = objectInput.readUTF();
            int n = objectInput.readInt();
            this.args = new Object[n];
            for (int i = 0; i < n; ++i) {
                this.args[i] = objectInput.readObject();
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeUTF(this.method);
            objectOutput.writeInt(this.args.length);
            for (int i = 0; i < this.args.length; ++i) {
                objectOutput.writeObject(this.args[i]);
            }
        }
    }

    private static class ObjectFrame
    extends CommFrame
    implements Externalizable {
        private static final long serialVersionUID = -7212430608484116919L;
        ChannelListener _continuation;

        public ObjectFrame() {
        }

        public ObjectFrame(CommGroupFrame commGroupFrame, ChannelFrame channelFrame, ChannelListener channelListener) {
            super(commGroupFrame, channelFrame);
            this._continuation = channelListener;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            super.readExternal(objectInput);
            this._continuation = (ChannelListener)objectInput.readObject();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            super.writeExternal(objectOutput);
            objectOutput.writeObject(this._continuation);
        }
    }

    private static class CommFrame
    implements Externalizable {
        CommGroupFrame commGroupFrame;
        ChannelFrame channelFrame;

        public CommFrame() {
        }

        CommFrame(CommGroupFrame commGroupFrame, ChannelFrame channelFrame) {
            this.commGroupFrame = commGroupFrame;
            this.channelFrame = channelFrame;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.commGroupFrame = (CommGroupFrame)objectInput.readObject();
            this.channelFrame = (ChannelFrame)objectInput.readObject();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.commGroupFrame);
            objectOutput.writeObject(this.channelFrame);
        }
    }

    private static class CommGroupFrame
    implements Serializable {
        boolean replicated;
        public Set<CommFrame> commFrames = new HashSet<CommFrame>();

        public CommGroupFrame(boolean bl) {
            this.replicated = bl;
        }
    }

    private static class ChannelFrame
    implements Externalizable {
        Class type;
        int id;
        int refCount;
        boolean replicatedSend;
        boolean replicatedRecv;
        Set<ObjectFrame> objFrames = new HashSet<ObjectFrame>();
        Set<MessageFrame> msgFrames = new HashSet<MessageFrame>();
        public String description;

        public ChannelFrame() {
        }

        public ChannelFrame(Class clazz, int n, String string, String string2) {
            this.type = clazz;
            this.id = n;
            this.description = string2;
        }

        public Integer getId() {
            return this.id;
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            int n;
            this.type = (Class)objectInput.readObject();
            this.id = objectInput.readInt();
            this.description = objectInput.readUTF();
            this.refCount = objectInput.readInt();
            this.replicatedSend = objectInput.readBoolean();
            this.replicatedRecv = objectInput.readBoolean();
            int n2 = objectInput.readInt();
            for (n = 0; n < n2; ++n) {
                this.objFrames.add((ObjectFrame)objectInput.readObject());
            }
            n2 = objectInput.readInt();
            for (n = 0; n < n2; ++n) {
                this.msgFrames.add((MessageFrame)objectInput.readObject());
            }
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.type);
            objectOutput.writeInt(this.id);
            objectOutput.writeUTF(this.description == null ? "" : this.description);
            objectOutput.writeInt(this.refCount);
            objectOutput.writeBoolean(this.replicatedSend);
            objectOutput.writeBoolean(this.replicatedRecv);
            objectOutput.writeInt(this.objFrames.size());
            Iterator<CommFrame> iterator = this.objFrames.iterator();
            while (iterator.hasNext()) {
                objectOutput.writeObject(iterator.next());
            }
            objectOutput.writeInt(this.msgFrames.size());
            iterator = this.msgFrames.iterator();
            while (iterator.hasNext()) {
                objectOutput.writeObject(iterator.next());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append("{CFRAME ");
            stringBuffer.append(this.type.getSimpleName());
            stringBuffer.append(':');
            stringBuffer.append(this.description);
            stringBuffer.append('#');
            stringBuffer.append(this.id);
            stringBuffer.append(" refCount=");
            stringBuffer.append(this.refCount);
            stringBuffer.append(", msgs=");
            stringBuffer.append(this.msgFrames.size());
            if (this.replicatedSend) {
                stringBuffer.append("R");
            }
            stringBuffer.append(", objs=");
            stringBuffer.append(this.objFrames.size());
            if (this.replicatedRecv) {
                stringBuffer.append("R");
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }
}

