/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JacobObject
implements Serializable {
    public abstract Set<Method> getImplementedMethods();

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected static Object getExtension(Class clazz) {
        return JacobVPU.activeJacobThread().getExtension(clazz);
    }

    protected static <T extends Channel> T importChannel(String string, Class<T> clazz) {
        return (T)JacobVPU.activeJacobThread().importChannel(string, clazz);
    }

    protected static void instance(JacobRunnable jacobRunnable) {
        JacobVPU.activeJacobThread().instance(jacobRunnable);
    }

    protected <T extends Channel> T newChannel(Class<T> clazz) throws IllegalArgumentException {
        return this.newChannel(clazz, null);
    }

    protected <T extends Channel> T newChannel(Class<T> clazz, String string) throws IllegalArgumentException {
        return (T)JacobVPU.activeJacobThread().newChannel(clazz, this.getClassName(), string);
    }

    protected static <T extends Channel> T object(ChannelListener<T> channelListener) {
        JacobVPU.activeJacobThread().object(false, channelListener);
        return channelListener.getChannel();
    }

    protected static void object(boolean bl, ChannelListener channelListener) {
        JacobVPU.activeJacobThread().object(bl, channelListener);
    }

    protected static void object(boolean bl, ChannelListener[] channelListenerArray) {
        JacobVPU.activeJacobThread().object(bl, channelListenerArray);
    }

    protected static void object(boolean bl, Set<ChannelListener> set) {
        JacobVPU.activeJacobThread().object(bl, set.toArray(new ChannelListener[set.size()]));
    }

    protected static <T extends Channel> T replication(ChannelListener<T> channelListener) {
        JacobVPU.activeJacobThread().object(true, channelListener);
        return channelListener.getChannel();
    }

    protected static <T extends Channel> T replication(T t) {
        return t;
    }

    public Method getMethod(String string) {
        Set<Method> set = this.getImplementedMethods();
        for (Method method : set) {
            if (!method.getName().equals(string)) continue;
            return method;
        }
        throw new IllegalArgumentException("No such method \"" + string + "\"!");
    }

    public String toString() {
        return "<JacobObject:" + this.getClassName() + ">";
    }
}

