/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.JacobObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChannelListener<CT extends Channel>
extends JacobObject {
    private static Log __log = LogFactory.getLog(ChannelListener.class);
    private transient Set<Method> _implementedMethods;
    private transient CT _channel;

    protected ChannelListener(CT CT) throws IllegalStateException {
        assert (this.getClass().getSuperclass().getSuperclass() == ChannelListener.class) : "Inheritance in ChannelListener classes not allowed!";
        if (CT == null) {
            throw new IllegalArgumentException("Null channel!");
        }
        this._channel = CT;
    }

    public CT getChannel() {
        return this._channel;
    }

    public void setChannel(CT CT) {
        this._channel = CT;
    }

    public Set<ChannelListener> or(ChannelListener channelListener) {
        HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>();
        hashSet.add(this);
        hashSet.add(channelListener);
        return hashSet;
    }

    public Set<ChannelListener> or(Set<ChannelListener> set) {
        HashSet<ChannelListener> hashSet = new HashSet<ChannelListener>(set);
        hashSet.add(this);
        return hashSet;
    }

    @Override
    public Set<Method> getImplementedMethods() {
        if (this._implementedMethods == null) {
            HashSet<Method> hashSet = new HashSet<Method>();
            ChannelListener.getImplementedMethods(hashSet, this.getClass().getSuperclass());
            this._implementedMethods = Collections.unmodifiableSet(hashSet);
        }
        return this._implementedMethods;
    }

    private static Set<Method> getImplementedMethods(Set<Method> set, Class clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (classArray[i] == Channel.class) continue;
            Method[] methodArray = classArray[i].getDeclaredMethods();
            for (int j = 0; j < methodArray.length; ++j) {
                set.add(methodArray[j]);
            }
            ChannelListener.getImplementedMethods(set, classArray[i]);
        }
        return set;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClassName());
        stringBuffer.append('{');
        for (Method method : this.getImplementedMethods()) {
            stringBuffer.append(method.getName());
            stringBuffer.append("()");
            stringBuffer.append("&");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    protected Log log() {
        return __log;
    }
}

