/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.scanner;

import jakarta.servlet.ServletContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.webbeans.corespi.scanner.AbstractMetaDataDiscovery;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class WebScannerService
extends AbstractMetaDataDiscovery {
    public static final String WEB_INF_BEANS_XML = "/WEB-INF/beans.xml";
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebScannerService.class);
    protected ServletContext servletContext;

    @Override
    public void init(Object context) {
        super.init(context);
        this.servletContext = (ServletContext)context;
    }

    @Override
    protected void configure() {
        ClassLoader loader = WebBeansUtil.getCurrentClassLoader();
        this.addWarBeansArchive();
        this.registerBeanArchives(loader);
    }

    public OwbAnnotationFinder getFinder() {
        return this.finder;
    }

    protected void addWarBeansArchive() {
        if (this.servletContext == null) {
            return;
        }
        URL url = null;
        try {
            url = this.servletContext.getResource(WEB_INF_BEANS_XML);
        }
        catch (MalformedURLException e) {
            ExceptionUtil.throwAsRuntimeException(e);
        }
        if (url != null) {
            this.addWebBeansXmlLocation(url);
            logger.info("Adding information from WEB-INF/beans.xml");
        }
    }
}

