/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.context;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ConversationService;
import org.apache.webbeans.web.context.WebContextsService;

public class WebConversationService
implements ConversationService {
    public static final String REQUEST_PARAM_CONVERSATION_ID = "cid";
    public static final String REQUEST_PARAM_SUPPRESS_CONVERSATION_PROPAGATION = "conversationPropagation";
    public static final String SESSION_CONVERSATION_ID_PARAM_NAME = "openWebBeansConversationIdCounter";
    private final WebBeansContext webBeansContext;
    private AtomicInteger nonServletRequestConversationIdCounter = new AtomicInteger(0);

    public WebConversationService(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    @Override
    public String getConversationId() {
        String suppressConversationPropagation;
        String cidParamValue;
        ServletRequest servletRequest = this.getCurrentServletRequest();
        if (servletRequest != null && (cidParamValue = servletRequest.getParameter(REQUEST_PARAM_CONVERSATION_ID)) != null && cidParamValue.length() > 0 && !"none".equals(suppressConversationPropagation = servletRequest.getParameter(REQUEST_PARAM_SUPPRESS_CONVERSATION_PROPAGATION))) {
            return cidParamValue;
        }
        return null;
    }

    @Override
    public String generateConversationId() {
        return Long.toString(this.getConversationIdCounter().incrementAndGet());
    }

    protected AtomicInteger getConversationIdCounter() {
        AtomicInteger counter = this.getSessionConversationIdCounter();
        return counter != null ? counter : this.nonServletRequestConversationIdCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AtomicInteger getSessionConversationIdCounter() {
        ServletRequest servletRequest = this.getCurrentServletRequest();
        if (servletRequest instanceof HttpServletRequest) {
            HttpSession session = ((HttpServletRequest)servletRequest).getSession(true);
            AtomicInteger sessionCounter = (AtomicInteger)session.getAttribute(SESSION_CONVERSATION_ID_PARAM_NAME);
            if (sessionCounter == null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    sessionCounter = (AtomicInteger)session.getAttribute(SESSION_CONVERSATION_ID_PARAM_NAME);
                    if (sessionCounter == null) {
                        sessionCounter = new AtomicInteger(0);
                        session.setAttribute(SESSION_CONVERSATION_ID_PARAM_NAME, sessionCounter);
                    }
                }
            }
            return sessionCounter;
        }
        return null;
    }

    protected ServletRequest getCurrentServletRequest() {
        ContextsService contextsService = this.webBeansContext.getContextsService();
        if (contextsService instanceof WebContextsService) {
            return ((WebContextsService)contextsService).getRequestContext(false).getServletRequest();
        }
        return null;
    }
}

