/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.context;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.ContextException;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.inject.Singleton;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.webbeans.annotation.BeforeDestroyedLiteral;
import org.apache.webbeans.annotation.DestroyedLiteral;
import org.apache.webbeans.annotation.InitializedLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContextsService;
import org.apache.webbeans.context.ApplicationContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.DependentContext;
import org.apache.webbeans.context.RequestContext;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SingletonContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.intercept.RequestScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.SessionScopedBeanInterceptorHandler;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.web.context.ServletRequestContext;

public class WebContextsService
extends AbstractContextsService {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebContextsService.class);
    private static final String OWB_SESSION_CONTEXT_ATTRIBUTE_NAME = "openWebBeansSessionContext";
    private final boolean destroySessionImmediately = false;
    protected ApplicationContext applicationContext;
    protected SingletonContext singletonContext;
    protected ThreadLocal<ServletRequestContext> requestContexts;
    protected ThreadLocal<SessionContext> sessionContexts;
    protected ThreadLocal<ConversationContext> conversationContexts;
    protected DependentContext dependentContext;
    protected final ConversationManager conversationManager;
    protected Boolean eagerSessionInitialisation;
    protected Pattern eagerSessionPattern;

    public WebContextsService(WebBeansContext webBeansContext) {
        super(webBeansContext);
        this.conversationManager = webBeansContext.getConversationManager();
        this.applicationContext = new ApplicationContext();
        this.applicationContext.setActive(true);
        this.requestContexts = new ThreadLocal();
        this.sessionContexts = new ThreadLocal();
        this.conversationContexts = new ThreadLocal();
        this.dependentContext = new DependentContext();
        this.dependentContext.setActive(true);
        this.configureEagerSessionInitialisation(webBeansContext);
    }

    protected void configureEagerSessionInitialisation(WebBeansContext webBeansContext) {
        String val = webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.web.eagerSessionInitialisation");
        if (val == null || val.isEmpty() || "false".equalsIgnoreCase(val)) {
            this.eagerSessionInitialisation = Boolean.FALSE;
            logger.fine("EagerSessionInitialisation is configured to FALSE (Session will get created lazily on first use)");
        } else if ("true".equalsIgnoreCase(val)) {
            this.eagerSessionInitialisation = Boolean.TRUE;
            logger.fine("EagerSessionInitialisation is configured to TRUE (Session will get created at the beginning of a request)");
        } else {
            logger.fine("EagerSessionInitialisation used for all URIs with RegExp " + val);
            this.eagerSessionPattern = Pattern.compile(val);
        }
    }

    @Override
    public void removeThreadLocals() {
        this.requestContexts.remove();
        this.sessionContexts.remove();
        this.conversationContexts.remove();
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
    }

    @Override
    public void init(Object initializeObject) {
        this.startContext(Singleton.class, initializeObject);
        this.startContext(ApplicationScoped.class, initializeObject);
    }

    @Override
    public void destroy(Object destroyObject) {
        ConversationContext conversationCtx;
        SessionContext sessionCtx;
        RequestContext requestCtx = this.requestContexts.get();
        if (requestCtx != null) {
            requestCtx.destroy();
            this.requestContexts.set(null);
            this.requestContexts.remove();
        }
        if ((sessionCtx = this.sessionContexts.get()) != null) {
            sessionCtx.destroy();
            this.sessionContexts.set(null);
            this.sessionContexts.remove();
        }
        if ((conversationCtx = this.conversationContexts.get()) != null) {
            conversationCtx.destroy();
            this.conversationContexts.set(null);
            this.conversationContexts.remove();
        }
        if (this.singletonContext != null) {
            this.singletonContext.destroy();
            this.singletonContext = null;
        }
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
            this.applicationContext.destroySystemBeans();
        }
    }

    @Override
    public void endContext(Class<? extends Annotation> scopeType, Object endParameters) {
        if (scopeType.equals(RequestScoped.class)) {
            this.destroyRequestContext(endParameters);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.destroySessionContext(endParameters);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.destroyApplicationContext(endParameters);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.destroyConversationContext();
        } else {
            if (scopeType.equals(Dependent.class)) {
                return;
            }
            if (scopeType.equals(Singleton.class)) {
                this.destroySingletonContext(endParameters);
            } else {
                logger.warning("CDI-OpenWebBeans container does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
            }
        }
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType, boolean createIfNotExists) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext(createIfNotExists);
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext(createIfNotExists);
        }
        return this.getCurrentContext(scopeType);
    }

    @Override
    public Context getCurrentContext(Class<? extends Annotation> scopeType) {
        if (scopeType.equals(RequestScoped.class)) {
            return this.getRequestContext(false);
        }
        if (scopeType.equals(SessionScoped.class)) {
            return this.getSessionContext(true);
        }
        if (scopeType.equals(ApplicationScoped.class)) {
            return this.applicationContext;
        }
        if (scopeType.equals(ConversationScoped.class)) {
            return this.getConversationContext(false, false);
        }
        if (scopeType.equals(Dependent.class)) {
            return this.dependentContext;
        }
        if (scopeType.equals(Singleton.class)) {
            return this.singletonContext;
        }
        return null;
    }

    @Override
    public void startContext(Class<? extends Annotation> scopeType, Object startParameter) throws ContextException {
        if (scopeType.equals(RequestScoped.class)) {
            this.initRequestContext(startParameter);
        } else if (scopeType.equals(SessionScoped.class)) {
            this.initSessionContext(startParameter);
        } else if (scopeType.equals(ApplicationScoped.class)) {
            this.initApplicationContext(startParameter);
        } else if (this.supportsConversation && scopeType.equals(ConversationScoped.class)) {
            this.initConversationContext(startParameter);
        } else {
            if (scopeType.equals(Dependent.class)) {
                return;
            }
            if (scopeType.equals(Singleton.class)) {
                this.initSingletonContext(startParameter);
            } else {
                logger.warning("CDI-OpenWebBeans container does not support context scope " + scopeType.getSimpleName() + ". Scopes @Dependent, @RequestScoped, @ApplicationScoped and @Singleton are supported scope types");
            }
        }
    }

    protected void initRequestContext(Object startupObject) {
        ServletRequestContext requestContext = new ServletRequestContext();
        requestContext.setActive(true);
        this.requestContexts.set(requestContext);
        Object payload = null;
        if (startupObject instanceof ServletRequestEvent) {
            HttpServletRequest request = (HttpServletRequest)((ServletRequestEvent)startupObject).getServletRequest();
            requestContext.setServletRequest(request);
            if (request != null) {
                payload = request;
                if (this.shouldEagerlyInitializeSession(request)) {
                    request.getSession(true);
                }
            }
        }
        if (this.shouldFireRequestLifecycleEvents()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload != null ? payload : new Object(), InitializedLiteral.INSTANCE_REQUEST_SCOPED);
        }
    }

    protected boolean shouldEagerlyInitializeSession(HttpServletRequest request) {
        if (this.eagerSessionPattern != null) {
            String requestURI = request.getRequestURI();
            Matcher matcher = this.eagerSessionPattern.matcher(requestURI);
            return matcher.matches();
        }
        return this.eagerSessionInitialisation;
    }

    protected void destroyRequestContext(Object endObject) {
        ServletRequestContext context = this.getRequestContext(false);
        if (context == null) {
            return;
        }
        if (this.supportsConversation) {
            this.destroyOutdatedConversations(this.conversationContexts.get());
        }
        if (context.getPropagatedSessionContext() != null) {
            SessionContext sessionContext = context.getPropagatedSessionContext();
            Object payload = null;
            if (context.getServletRequest() != null && (payload = context.getHttpSession()) == null) {
                payload = context.getServletRequest().getSession(false);
            }
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload != null ? payload : new Object(), BeforeDestroyedLiteral.INSTANCE_SESSION_SCOPED);
            sessionContext.destroy();
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload != null ? payload : new Object(), DestroyedLiteral.INSTANCE_SESSION_SCOPED);
        }
        ServletRequest payload = null;
        if (this.shouldFireRequestLifecycleEvents()) {
            if (endObject != null && endObject instanceof ServletRequestEvent) {
                payload = ((ServletRequestEvent)endObject).getServletRequest();
            }
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload != null ? payload : new Object(), BeforeDestroyedLiteral.INSTANCE_REQUEST_SCOPED);
        }
        context.destroy();
        ELContextStore elStore = ELContextStore.getInstance(false);
        if (elStore != null) {
            elStore.destroyELContextStore();
        }
        if (this.shouldFireRequestLifecycleEvents()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload != null ? payload : new Object(), DestroyedLiteral.INSTANCE_REQUEST_SCOPED);
        }
        RequestScopedBeanInterceptorHandler.removeThreadLocals();
        SessionScopedBeanInterceptorHandler.removeThreadLocals();
        this.requestContexts.set(null);
        this.requestContexts.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSessionContext(Object startupObject) {
        HttpSession session;
        HttpSession httpSession = session = startupObject instanceof HttpSession ? (HttpSession)startupObject : null;
        if (session != null) {
            SessionContext currentSessionContext = (SessionContext)session.getAttribute(OWB_SESSION_CONTEXT_ATTRIBUTE_NAME);
            if (currentSessionContext == null) {
                HttpSession httpSession2 = session;
                synchronized (httpSession2) {
                    currentSessionContext = (SessionContext)session.getAttribute(OWB_SESSION_CONTEXT_ATTRIBUTE_NAME);
                    if (currentSessionContext == null) {
                        currentSessionContext = new SessionContext();
                        currentSessionContext.setActive(true);
                        session.setAttribute(OWB_SESSION_CONTEXT_ATTRIBUTE_NAME, currentSessionContext);
                        this.sessionContexts.set(currentSessionContext);
                        this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(session, InitializedLiteral.INSTANCE_SESSION_SCOPED);
                    }
                }
            } else {
                session.setAttribute(OWB_SESSION_CONTEXT_ATTRIBUTE_NAME, currentSessionContext);
                currentSessionContext.setActive(true);
                this.sessionContexts.set(currentSessionContext);
            }
        }
    }

    protected void destroySessionContext(Object endObject) {
        SessionContext context = this.sessionContexts.get();
        HttpSession session = null;
        boolean sessionIsExpiring = false;
        if (endObject instanceof HttpSession) {
            session = (HttpSession)endObject;
            if (context == null && session.getAttribute(OWB_SESSION_CONTEXT_ATTRIBUTE_NAME) != null) {
                sessionIsExpiring = this.sessionIsExpiring(session);
                this.initSessionContext(session);
                context = this.sessionContexts.get();
            }
        }
        if (context != null && context.isActive()) {
            ServletRequestContext requestContext = this.getRequestContext(true);
            if (requestContext == null || requestContext.getServletRequest() == null || requestContext.getServletRequest().getSession(false) == null || sessionIsExpiring) {
                this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(session != null ? session : new Object(), BeforeDestroyedLiteral.INSTANCE_SESSION_SCOPED);
                context.destroy();
                this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(session != null ? session : new Object(), DestroyedLiteral.INSTANCE_SESSION_SCOPED);
                this.sessionContexts.set(null);
                this.sessionContexts.remove();
            } else {
                requestContext.setPropagatedSessionContext(context);
                requestContext.setHttpSession(session);
            }
        }
        SessionScopedBeanInterceptorHandler.removeThreadLocals();
    }

    protected boolean sessionIsExpiring(HttpSession session) {
        long inactiveSince;
        int maxInactiveInterval = session.getMaxInactiveInterval();
        return maxInactiveInterval > 0 && (inactiveSince = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - session.getLastAccessedTime())) >= (long)maxInactiveInterval;
    }

    protected void initApplicationContext(Object startupObject) {
        if (this.applicationContext != null && !this.applicationContext.isDestroyed()) {
            this.applicationContext.setActive(true);
            return;
        }
        ApplicationContext newApplicationContext = new ApplicationContext();
        newApplicationContext.setActive(true);
        if (this.applicationContext == null) {
            this.applicationContext = newApplicationContext;
        }
    }

    protected void destroyApplicationContext(Object endObject) {
        if (this.applicationContext != null && !this.applicationContext.isDestroyed()) {
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(endObject != null ? endObject : new Object(), BeforeDestroyedLiteral.INSTANCE_APPLICATION_SCOPED);
            this.applicationContext.destroy();
            this.webBeansContext.getBeanManagerImpl().clearCacheProxies();
            Object payload = endObject instanceof ServletContext ? endObject : new Object();
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload, DestroyedLiteral.INSTANCE_APPLICATION_SCOPED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initSingletonContext(Object startupObject) {
        if (this.singletonContext != null) {
            return;
        }
        WebContextsService webContextsService = this;
        synchronized (webContextsService) {
            if (this.singletonContext == null) {
                this.singletonContext = new SingletonContext();
                this.singletonContext.setActive(true);
                Object payLoad = startupObject instanceof ServletContext ? (ServletContext)startupObject : new Object();
                this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payLoad, InitializedLiteral.INSTANCE_SINGLETON_SCOPED);
            }
        }
    }

    protected void destroySingletonContext(Object endObject) {
        if (this.singletonContext != null) {
            Object payload = endObject != null ? endObject : new Object();
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload, BeforeDestroyedLiteral.INSTANCE_SINGLETON_SCOPED);
            this.singletonContext.destroy();
            this.singletonContext = null;
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(payload, DestroyedLiteral.INSTANCE_SINGLETON_SCOPED);
        }
    }

    protected void initConversationContext(Object startObject) {
        if (this.conversationContexts.get() != null) {
            return;
        }
        if (startObject instanceof ConversationContext) {
            ConversationContext context = (ConversationContext)startObject;
            context.setActive(true);
            this.conversationContexts.set(context);
        }
    }

    protected void destroyConversationContext() {
        if (this.conversationContexts.get() == null) {
            return;
        }
        ConversationContext context = this.getConversationContext(false, true);
        if (context != null) {
            context.destroy();
            this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(new Object(), DestroyedLiteral.INSTANCE_SINGLETON_SCOPED);
        }
        this.conversationContexts.set(null);
        this.conversationContexts.remove();
    }

    public ServletRequestContext getRequestContext(boolean create) {
        ServletRequestContext requestContext = this.requestContexts.get();
        if (requestContext == null && create) {
            this.initRequestContext(null);
            requestContext = this.requestContexts.get();
        }
        return requestContext;
    }

    public SessionContext getSessionContext(boolean forceCreate) {
        SessionContext context = this.sessionContexts.get();
        if (null == context && forceCreate) {
            this.lazyStartSessionContext(true);
            context = this.sessionContexts.get();
        }
        return context;
    }

    public ConversationContext getConversationContext(boolean create, boolean ignoreProblems) {
        SessionContext sessionContext;
        ConversationContext conversationContext = this.conversationContexts.get();
        if (conversationContext == null && (sessionContext = this.getSessionContext(true)) != null) {
            conversationContext = this.conversationManager.getConversationContext(sessionContext);
            this.conversationContexts.set(conversationContext);
            if (conversationContext.getConversation().isTransient()) {
                this.webBeansContext.getBeanManagerImpl().fireContextLifecyleEvent(this.conversationManager.getLifecycleEventPayload(conversationContext), InitializedLiteral.INSTANCE_CONVERSATION_SCOPED);
            }
            if (!ignoreProblems && conversationContext.getConversation().getProblemDuringCreation() != null) {
                throw conversationContext.getConversation().getProblemDuringCreation();
            }
        }
        return conversationContext;
    }

    private void lazyStartSessionContext(boolean createSession) {
        ServletRequestContext requestContext;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, ">lazyStartSessionContext");
        }
        if ((requestContext = this.getRequestContext(false)) == null) {
            if (createSession) {
                logger.log(Level.WARNING, "Could NOT lazily initialize session context because NO active request context");
            }
            return;
        }
        HttpServletRequest servletRequest = requestContext.getServletRequest();
        if (servletRequest != null) {
            try {
                HttpSession currentSession = servletRequest.getSession(createSession);
                if (currentSession != null) {
                    this.initSessionContext(currentSession);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Lazy SESSION context initialization SUCCESS");
                    }
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0013", e));
            }
        }
    }
}

