/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import jakarta.enterprise.inject.Alternative;
import jakarta.enterprise.inject.Specializes;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.InconsistentSpecializationException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.WebBeansUtil;

public class SpecializationUtil {
    private final AlternativesManager alternativesManager;
    private final WebBeansUtil webBeansUtil;
    private final WebBeansContext webBeansContext;
    private final OpenWebBeansEjbPlugin ejbPlugin;

    public SpecializationUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.alternativesManager = webBeansContext.getAlternativesManager();
        this.webBeansUtil = webBeansContext.getWebBeansUtil();
        this.ejbPlugin = webBeansContext.getPluginLoader().getEjbPlugin();
    }

    public void removeDisabledBeanAttributes(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, BeansDeployer.ExtendedBeanAttributes<?>>> beanAttributesPerBda, BeanAttributesProvider attributeProvider, boolean notSpecializationOnly) {
        Set<AnnotatedType<?>> allAnnotatedTypes = this.getAllAnnotatedTypes(beanAttributesPerBda);
        if (allAnnotatedTypes != null && !allAnnotatedTypes.isEmpty()) {
            HashSet superClassList = new HashSet();
            HashSet disabledClasses = new HashSet();
            for (AnnotatedType<?> annotatedType : allAnnotatedTypes) {
                BeanAttributes<?> ba;
                if (annotatedType.getAnnotation(Specializes.class) == null || !this.isEnabled(annotatedType)) continue;
                Class<?> specialClass = annotatedType.getJavaClass();
                Class<?> superClass = specialClass.getSuperclass();
                if (this.ejbPlugin != null && this.ejbPlugin.isSessionBean(superClass) && !this.ejbPlugin.isSessionBean(specialClass)) {
                    throw new WebBeansConfigurationException(specialClass + " specializes and EJB " + superClass + ". That's forbidden.");
                }
                if (!(attributeProvider == null || (ba = attributeProvider.get(annotatedType)) != null && ba.getTypes().contains(superClass))) {
                    throw new WebBeansDeploymentException(new InconsistentSpecializationException("@Specializes class " + specialClass.getName() + " does not extend a bean with a valid bean constructor - removed with ProcessBeanAttribute"));
                }
                if (superClass.equals(Object.class)) {
                    throw new WebBeansDeploymentException(new WebBeansConfigurationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0003") + specialClass.getName() + WebBeansLoggerFacade.getTokenString("EXCEPT_0004")));
                }
                if (superClassList.contains(superClass)) {
                    throw new WebBeansDeploymentException(new InconsistentSpecializationException(WebBeansLoggerFacade.getTokenString("EXCEPT_0005") + superClass.getName()));
                }
                if (!this.containsAllSuperclassTypes(annotatedType, superClass, allAnnotatedTypes)) {
                    throw new WebBeansDeploymentException(new InconsistentSpecializationException("@Specialized Class : " + specialClass.getName() + " must have all bean types of its super class"));
                }
                AnnotatedType<?> superType = this.getAnnotatedTypeForClass(allAnnotatedTypes, superClass);
                if (notSpecializationOnly) {
                    if (superType == null && !this.webBeansContext.findMissingAnnotatedType(superClass) || superType != null && !this.webBeansUtil.isConstructorOk(superType)) {
                        throw new WebBeansDeploymentException(new InconsistentSpecializationException("@Specializes class " + specialClass.getName() + " does not extend a bean with a valid bean constructor"));
                    }
                    try {
                        this.webBeansUtil.checkManagedBean(specialClass);
                    }
                    catch (WebBeansConfigurationException illegalBeanTypeException) {
                        throw new WebBeansDeploymentException(new InconsistentSpecializationException("@Specializes class " + specialClass.getName() + " does not extend a valid bean type", illegalBeanTypeException));
                    }
                }
                superClassList.add(superClass);
                while (!superClass.equals(Object.class)) {
                    disabledClasses.add(superClass);
                    superClass = superClass.getSuperclass();
                }
            }
            this.removeAllDisabledClasses(beanAttributesPerBda, disabledClasses);
        }
    }

    private void removeAllDisabledClasses(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, BeansDeployer.ExtendedBeanAttributes<?>>> beanAttributesPerBda, Set<Class<?>> disabledClasses) {
        for (Map<AnnotatedType<?>, BeansDeployer.ExtendedBeanAttributes<?>> beanAttributeMap : beanAttributesPerBda.values()) {
            beanAttributeMap.entrySet().removeIf(beanAttributesEntry -> disabledClasses.contains(((AnnotatedType)beanAttributesEntry.getKey()).getJavaClass()));
        }
    }

    private Set<AnnotatedType<?>> getAllAnnotatedTypes(Map<BeanArchiveService.BeanArchiveInformation, Map<AnnotatedType<?>, BeansDeployer.ExtendedBeanAttributes<?>>> beanAttributesPerBda) {
        HashSet allAnnotatedTypes = new HashSet(beanAttributesPerBda.size() * 50);
        for (Map<AnnotatedType<?>, BeansDeployer.ExtendedBeanAttributes<?>> annotatedTypeMap : beanAttributesPerBda.values()) {
            allAnnotatedTypes.addAll(annotatedTypeMap.keySet());
        }
        return allAnnotatedTypes;
    }

    private boolean containsAllSuperclassTypes(AnnotatedType<?> annotatedType, Class<?> superClass, Collection<AnnotatedType<?>> annotatedTypes) {
        Typed typed = annotatedType.getAnnotation(Typed.class);
        if (typed != null) {
            List<Class<Type>> typeList = Arrays.asList(typed.value());
            AnnotatedType<?> superType = this.getAnnotatedTypeForClass(annotatedTypes, superClass);
            if (superType != null) {
                Set<Type> superClassTypes;
                Typed superClassTyped = superType.getAnnotation(Typed.class);
                if (superClassTyped != null) {
                    superClassTypes = new HashSet(Arrays.asList(superClassTyped.value()));
                } else {
                    superClassTypes = superType.getTypeClosure();
                    superClassTypes.remove(Object.class);
                }
                return typeList.containsAll(superClassTypes);
            }
        }
        return true;
    }

    private AnnotatedType<?> getAnnotatedTypeForClass(Collection<AnnotatedType<?>> annotatedTypes, Class<?> clazz) {
        for (AnnotatedType<?> annotatedType : annotatedTypes) {
            if (!annotatedType.getJavaClass().equals(clazz)) continue;
            return annotatedType;
        }
        return null;
    }

    private boolean isEnabled(AnnotatedType<?> annotatedType) {
        return annotatedType.getAnnotation(Alternative.class) == null || this.alternativesManager.isAlternative(annotatedType.getJavaClass(), this.getAnnotationClasses(annotatedType));
    }

    private Set<Class<? extends Annotation>> getAnnotationClasses(AnnotatedType<?> annotatedType) {
        Set<Annotation> annotations = annotatedType.getAnnotations();
        if (annotations != null && !annotations.isEmpty()) {
            HashSet<Class<? extends Annotation>> annotationClasses = new HashSet<Class<? extends Annotation>>(annotations.size());
            for (Annotation annotation : annotations) {
                annotationClasses.add(annotation.annotationType());
            }
            return annotationClasses;
        }
        return Collections.emptySet();
    }

    public static interface BeanAttributesProvider {
        public <T> BeanAttributes<T> get(AnnotatedType<T> var1);
    }
}

