/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.context.spi.Context;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationListener.class);
    protected ContainerLifecycle lifeCycle;
    private WebBeansContext webBeansContext = WebBeansContext.getInstance();
    private ContextsService contextsService = this.webBeansContext.getContextsService();

    @Override
    public void contextInitialized(ServletContextEvent event) {
        this.doStart(event);
    }

    @Override
    public void requestInitialized(ServletRequestEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a new request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
            }
            this.lifeCycle.getContextService().startContext(RequestScoped.class, event);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0019", event == null ? "null" : event.getServletRequest()));
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    @Override
    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a session with session id : [{0}]", event.getSession().getId());
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, event.getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0020", event.getSession()));
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent event) {
        if (this.lifeCycle != null) {
            this.lifeCycle.stopApplication(event);
        }
        this.cleanupRequestThreadLocals();
    }

    @Override
    public void requestDestroyed(ServletRequestEvent event) {
        ELContextStore elStore;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a request : [{0}]", event == null ? "null" : event.getServletRequest().getRemoteAddr());
        }
        if ((elStore = ELContextStore.getInstance(false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, event);
        this.cleanupRequestThreadLocals();
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a session with session id : [{0}]", event.getSession().getId());
        }
        boolean mustDestroy = this.ensureRequestScope();
        this.lifeCycle.getContextService().endContext(SessionScoped.class, event.getSession());
        if (mustDestroy) {
            this.requestDestroyed(null);
        }
    }

    private void doStart(ServletContextEvent event) {
        if (event.getServletContext().getAttribute(this.getClass().getName()) != null) {
            return;
        }
        this.lifeCycle = this.webBeansContext.getService(ContainerLifecycle.class);
        try {
            this.lifeCycle.startApplication(event);
            event.getServletContext().setAttribute(this.getClass().getName(), true);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage("ERROR_0018", ServletCompatibilityUtil.getServletInfo(event.getServletContext())));
            WebBeansUtil.throwRuntimeExceptions(e);
        }
    }

    private boolean ensureRequestScope() {
        Context context = this.lifeCycle.getContextService().getCurrentContext(RequestScoped.class);
        if (context == null || !context.isActive()) {
            this.requestInitialized(null);
            return true;
        }
        return false;
    }

    private void cleanupRequestThreadLocals() {
        if (this.contextsService != null) {
            this.contextsService.removeThreadLocals();
        }
    }

    public static class Auto
    implements ServletContainerInitializer {
        @Override
        public void onStartup(Set<Class<?>> set, ServletContext servletContext) {
            String key = "openwebbeans.web.sci.active";
            if (!Boolean.parseBoolean(System.getProperty("openwebbeans.web.sci.active", servletContext.getInitParameter("openwebbeans.web.sci.active")))) {
                return;
            }
            WebBeansConfigurationListener listener = new WebBeansConfigurationListener();
            listener.doStart(new ServletContextEvent(servletContext));
            servletContext.addListener(listener);
        }
    }
}

