/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.service;

import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.DefiningClassService;
import org.apache.webbeans.spi.InstantiatingClassService;

public class ClassLoaderProxyService
implements DefiningClassService,
InstantiatingClassService {
    private final ProxiesClassLoader loader;

    public ClassLoaderProxyService(WebBeansContext context) {
        this.loader = new ProxiesClassLoader(context, Boolean.parseBoolean(context.getOpenWebBeansConfiguration().getProperty(this.getClass().getName() + ".skipPackages")));
    }

    protected ClassLoaderProxyService(ProxiesClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public ClassLoader getProxyClassLoader(Class<?> forClass) {
        return this.loader;
    }

    @Override
    public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
        return this.loader.getOrRegister(name, bytecode, proxiedClass.getPackage(), proxiedClass.getProtectionDomain());
    }

    @Override
    public <T> T newInstance(Class<? extends T> proxyClass) {
        try {
            return proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create a new Proxy instance of " + proxyClass.getName(), e);
        }
    }

    private static class ProxiesClassLoader
    extends ClassLoader {
        private final boolean skipPackages;
        private final ConcurrentMap<String, Class<?>> classes = new ConcurrentHashMap();

        private ProxiesClassLoader(WebBeansContext context, boolean skipPackages) {
            super(context.getApplicationBoundaryService().getApplicationClassLoader());
            this.skipPackages = skipPackages;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class clazz = (Class)this.classes.get(name);
            if (clazz == null) {
                return this.getParent().loadClass(name);
            }
            return clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Class<?> getOrRegister(String proxyClassName, byte[] proxyBytes, Package pck, ProtectionDomain protectionDomain) {
            String key = proxyClassName.replace('/', '.');
            Class<?> existing = (Class<?>)this.classes.get(key);
            if (existing == null) {
                ProxiesClassLoader proxiesClassLoader = this;
                synchronized (proxiesClassLoader) {
                    existing = (Class)this.classes.get(key);
                    if (existing == null) {
                        if (!this.skipPackages) {
                            this.definePackageFor(pck, protectionDomain);
                        }
                        existing = super.defineClass(proxyClassName, proxyBytes, 0, proxyBytes.length);
                        this.resolveClass(existing);
                        this.classes.put(key, existing);
                    }
                }
            }
            return existing;
        }

        private void definePackageFor(Package model, ProtectionDomain protectionDomain) {
            if (model == null) {
                return;
            }
            if (this.getPackage(model.getName()) == null) {
                if (model.isSealed() && protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null) {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), protectionDomain.getCodeSource().getLocation());
                } else {
                    this.definePackage(model.getName(), model.getSpecificationTitle(), model.getSpecificationVersion(), model.getSpecificationVendor(), model.getImplementationTitle(), model.getImplementationVersion(), model.getImplementationVendor(), null);
                }
            }
        }
    }

    public static class LoadOnly
    implements DefiningClassService,
    InstantiatingClassService {
        @Override
        public ClassLoader getProxyClassLoader(Class<?> forClass) {
            return Thread.currentThread().getContextClassLoader();
        }

        @Override
        public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
            try {
                return this.getProxyClassLoader(null).loadClass(name);
            }
            catch (ClassNotFoundException e) {
                WebBeansLoggerFacade.getLogger(this.getClass()).warning(e.getMessage());
                throw new WebBeansException(e);
            }
        }

        @Override
        public <T> T newInstance(Class<? extends T> proxyClass) {
            try {
                return proxyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to create a new Proxy instance of " + proxyClass.getName(), e);
            }
        }
    }

    public static class LoadFirst
    extends ClassLoaderProxyService {
        public LoadFirst(WebBeansContext context) {
            super(context);
        }

        @Override
        public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
            ClassLoader proxyClassLoader = this.getProxyClassLoader(proxiedClass);
            if (proxyClassLoader == null) {
                proxyClassLoader = Thread.currentThread().getContextClassLoader();
            }
            try {
                return proxyClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                WebBeansLoggerFacade.getLogger(this.getClass()).warning(e.getMessage());
                return super.defineAndLoad(name, bytecode, proxiedClass);
            }
        }
    }

    public static class Spy
    extends ClassLoaderProxyService {
        private final Map<String, byte[]> proxies = new HashMap<String, byte[]>();

        public Spy(WebBeansContext context) {
            super(new ProxiesClassLoader(context, true));
        }

        public Map<String, byte[]> getProxies() {
            return this.proxies;
        }

        @Override
        public <T> Class<T> defineAndLoad(String name, byte[] bytecode, Class<T> proxiedClass) {
            this.proxies.put(name, bytecode);
            return super.defineAndLoad(name, bytecode, proxiedClass);
        }
    }
}

