/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.deployment.StereoTypeModel;
import org.apache.webbeans.portable.events.EventBase;
import org.apache.webbeans.portable.events.discovery.AnnotatedTypeConfiguratorHolder;
import org.apache.webbeans.portable.events.discovery.ExtensionAware;

public class BeforeBeanDiscoveryImpl
extends EventBase
implements BeforeBeanDiscovery,
ExtensionAware {
    private BeanManagerImpl beanManager;
    private final WebBeansContext webBeansContext;
    private Extension extension;
    private Map<String, AnnotatedTypeConfiguratorHolder> annotatedTypeConfigurators = new HashMap<String, AnnotatedTypeConfiguratorHolder>();
    private Set<AnnotatedTypeConfiguratorImpl<?>> interceptorBindingConfigurators = new HashSet();
    private Set<AnnotatedTypeConfiguratorImpl<?>> qualifierConfigurators = new HashSet();

    public BeforeBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> type) {
        this.checkState();
        this.beanManager.addAdditionalAnnotatedType(this.extension, type);
    }

    @Override
    public void addQualifier(Class<? extends Annotation> qualifier) {
        this.checkState();
        this.beanManager.addAdditionalQualifier(qualifier);
    }

    @Override
    public void addInterceptorBinding(Class<? extends Annotation> binding, Annotation ... bindingDef) {
        this.checkState();
        this.webBeansContext.getInterceptorsManager().addInterceptorBindingType(binding, bindingDef);
    }

    @Override
    public void addScope(Class<? extends Annotation> scope, boolean normal, boolean passivating) {
        this.checkState();
        ExternalScope additionalScope = new ExternalScope(scope, normal, passivating);
        this.beanManager.addAdditionalScope(additionalScope);
    }

    @Override
    public void addStereotype(Class<? extends Annotation> stereotype, Annotation ... stereotypeDef) {
        this.checkState();
        this.webBeansContext.getAnnotationManager().checkStereoTypeClass(stereotype, stereotypeDef);
        StereoTypeModel model = new StereoTypeModel(this.webBeansContext, stereotype, stereotypeDef);
        this.webBeansContext.getStereoTypeManager().addStereoTypeModel(model);
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> annotatedType, String id) {
        this.checkState();
        this.beanManager.addAdditionalAnnotatedType(this.extension, annotatedType, id);
        String key = annotatedType.getJavaClass() + id;
        this.annotatedTypeConfigurators.remove(key);
    }

    @Override
    public <T> AnnotatedTypeConfigurator<T> addAnnotatedType(Class<T> clazz, String id) {
        this.checkState();
        String key = clazz.getName() + id;
        AnnotatedTypeConfiguratorHolder<T> configuratorHolder = this.annotatedTypeConfigurators.get(key);
        if (configuratorHolder == null) {
            AnnotatedTypeConfiguratorImpl<T> configurator = this.getAnnotatedTypeConfigurator(clazz);
            configuratorHolder = new AnnotatedTypeConfiguratorHolder<T>(this.extension, id, configurator);
            this.annotatedTypeConfigurators.put(key, configuratorHolder);
        }
        return configuratorHolder.getAnnotatedTypeConfigurator();
    }

    @Override
    public <T extends Annotation> AnnotatedTypeConfigurator<T> configureInterceptorBinding(Class<T> clazz) {
        this.checkState();
        AnnotatedTypeConfiguratorImpl<T> configurator = this.getAnnotatedTypeConfigurator(clazz);
        this.interceptorBindingConfigurators.add(configurator);
        return configurator;
    }

    @Override
    public <T extends Annotation> AnnotatedTypeConfigurator<T> configureQualifier(Class<T> clazz) {
        this.checkState();
        AnnotatedTypeConfiguratorImpl<T> configurator = this.getAnnotatedTypeConfigurator(clazz);
        this.qualifierConfigurators.add(configurator);
        return configurator;
    }

    @Override
    public void addInterceptorBinding(AnnotatedType<? extends Annotation> annotatedType) {
        this.checkState();
        this.webBeansContext.getInterceptorsManager().addInterceptorBindingType(annotatedType);
    }

    @Override
    public void addQualifier(AnnotatedType<? extends Annotation> annotatedType) {
        this.checkState();
        this.beanManager.addAdditionalQualifier(annotatedType);
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public Collection<AnnotatedTypeConfiguratorHolder> getAnnotatedTypeConfigurators() {
        return this.annotatedTypeConfigurators.values();
    }

    public Collection<AnnotatedTypeConfiguratorImpl<?>> getInterceptorBindingConfigurators() {
        return this.interceptorBindingConfigurators;
    }

    public Collection<AnnotatedTypeConfiguratorImpl<?>> getQualifierConfigurators() {
        return this.qualifierConfigurators;
    }

    private <T> AnnotatedTypeConfiguratorImpl<T> getAnnotatedTypeConfigurator(Class<T> clazz) {
        AnnotatedType<T> initialAnnotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
        return new AnnotatedTypeConfiguratorImpl<T>(this.webBeansContext, initialAnnotatedType);
    }
}

