/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.portable.events.EventBase;
import org.apache.webbeans.portable.events.discovery.AnnotatedTypeConfiguratorHolder;
import org.apache.webbeans.portable.events.discovery.ExtensionAware;

public class AfterTypeDiscoveryImpl
extends EventBase
implements AfterTypeDiscovery,
ExtensionAware {
    private final WebBeansContext webBeansContext;
    private final List<Class<?>> sortedAlternatives;
    private final List<Class<?>> sortedInterceptors;
    private final List<Class<?>> sortedDecorators;
    private final List<AnnotatedType<?>> newAt;
    private Map<String, AnnotatedTypeConfiguratorHolder> annotatedTypeConfigurators = new HashMap<String, AnnotatedTypeConfiguratorHolder>();
    private Extension extension;

    public AfterTypeDiscoveryImpl(WebBeansContext webBeansContext, List<AnnotatedType<?>> newAt, List<Class<?>> sortedInterceptors, List<Class<?>> sortedDecorators, List<Class<?>> sortedAlternatives) {
        this.webBeansContext = webBeansContext;
        this.newAt = newAt;
        this.sortedAlternatives = sortedAlternatives;
        this.sortedInterceptors = sortedInterceptors;
        this.sortedDecorators = sortedDecorators;
    }

    @Override
    public List<Class<?>> getAlternatives() {
        this.checkState();
        return this.sortedAlternatives;
    }

    @Override
    public List<Class<?>> getInterceptors() {
        this.checkState();
        return this.sortedInterceptors;
    }

    @Override
    public List<Class<?>> getDecorators() {
        this.checkState();
        return this.sortedDecorators;
    }

    @Override
    public void addAnnotatedType(AnnotatedType<?> type, String id) {
        this.checkState();
        this.webBeansContext.getBeanManagerImpl().addAdditionalAnnotatedType(this.extension, type, id);
        this.newAt.add(type);
    }

    @Override
    public <T> AnnotatedTypeConfigurator<T> addAnnotatedType(Class<T> clazz, String id) {
        this.checkState();
        String key = clazz.getName() + id;
        AnnotatedTypeConfiguratorHolder<T> configuratorHolder = this.annotatedTypeConfigurators.get(key);
        if (configuratorHolder == null) {
            AnnotatedTypeConfiguratorImpl<T> configurator = this.getAnnotatedTypeConfigurator(clazz);
            configuratorHolder = new AnnotatedTypeConfiguratorHolder<T>(this.extension, id, configurator);
            this.annotatedTypeConfigurators.put(key, configuratorHolder);
        }
        return configuratorHolder.getAnnotatedTypeConfigurator();
    }

    @Override
    public void setExtension(Extension instance) {
        this.extension = instance;
    }

    public Collection<AnnotatedTypeConfiguratorHolder> getAnnotatedTypeConfigurators() {
        return this.annotatedTypeConfigurators.values();
    }

    private <T> AnnotatedTypeConfiguratorImpl<T> getAnnotatedTypeConfigurator(Class<T> clazz) {
        AnnotatedType<T> initialAnnotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
        return new AnnotatedTypeConfiguratorImpl<T>(this.webBeansContext, initialAnnotatedType);
    }
}

