/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events.discovery;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.enterprise.inject.spi.configurator.ObserverMethodConfigurator;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.BeanConfiguratorImpl;
import org.apache.webbeans.configurator.ObserverMethodConfiguratorImpl;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.EventBase;
import org.apache.webbeans.portable.events.discovery.ExtensionAware;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticBean;
import org.apache.webbeans.portable.events.generics.GProcessSyntheticObserverMethod;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

public class AfterBeanDiscoveryImpl
extends EventBase
implements AfterBeanDiscovery,
ExtensionAware {
    private BeanManagerImpl beanManager;
    private static final Logger logger = WebBeansLoggerFacade.getLogger(AfterBeanDiscoveryImpl.class);
    private final WebBeansContext webBeansContext;
    private Set<BeanConfiguratorImpl<?>> beanConfigurators = new HashSet();
    private Set<ObserverMethodConfiguratorImpl<?>> observerMethodConfigurators = new HashSet();
    private Extension extension;

    public AfterBeanDiscoveryImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
    }

    @Override
    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    @Override
    public void addBean(Bean<?> bean) {
        this.checkState();
        if (bean.isAlternative() && !this.webBeansContext.getAlternativesManager().isAlternative(bean) && !(bean instanceof Prioritized) && !bean.getBeanClass().isAnnotationPresent(Priority.class)) {
            return;
        }
        AnnotatedType<?> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(bean.getBeanClass());
        GProcessSyntheticBean processSyntheticBean = new GProcessSyntheticBean(bean, annotatedType, this.extension);
        this.beanManager.fireEvent((Object)processSyntheticBean, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (bean instanceof Interceptor) {
            this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            Interceptor interceptor = (Interceptor)bean;
            if (interceptor.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_1", interceptor.getBeanClass().getName());
            }
            if (interceptor.getName() != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_2", interceptor.getBeanClass().getName());
            }
            if (interceptor.isAlternative() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_3", interceptor.getBeanClass().getName());
            }
            InterceptorsManager interceptorsManager = this.webBeansContext.getInterceptorsManager();
            interceptorsManager.addCdiInterceptor(interceptor);
            interceptorsManager.addCustomInterceptorClass(bean.getBeanClass());
        } else if (bean instanceof Decorator) {
            ManagedBean<?> managedBean = this.webBeansContext.getWebBeansUtil().defineManagedBeanWithoutFireEvents(annotatedType);
            if (managedBean.getScope() != Dependent.class && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_1", managedBean.getBeanClass().getName());
            }
            if (managedBean.getName() != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_2", managedBean.getBeanClass().getName());
            }
            if (managedBean.isAlternative() && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "WARN_0005_3", managedBean.getBeanClass().getName());
            }
            boolean found = false;
            for (InjectionPoint ip : bean.getInjectionPoints()) {
                if (!ip.isDelegate()) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point. But the decorator bean : " + managedBean.toString() + " has more than one");
            }
            this.webBeansContext.getDecoratorsManager().addDecorator((Decorator)bean);
            this.webBeansContext.getDecoratorsManager().addCustomDecoratorClass(bean.getBeanClass());
        } else {
            if (bean.isAlternative() && bean instanceof Prioritized) {
                this.webBeansContext.getAlternativesManager().addPrioritizedAlternativeBean(bean);
            }
            this.beanManager.addBean(bean);
        }
    }

    @Override
    public void addContext(Context context) {
        this.checkState();
        this.beanManager.addContext(context);
    }

    @Override
    public void addDefinitionError(Throwable t) {
        this.checkState();
        this.beanManager.getErrorStack().pushError(t);
    }

    @Override
    public void addObserverMethod(ObserverMethod<?> observerMethod) {
        GProcessSyntheticObserverMethod event;
        this.checkState();
        if (!ClassUtil.isMethodImplemented(observerMethod.getClass(), ObserverMethod.class, "notify", Object.class) && !ClassUtil.isMethodImplemented(observerMethod.getClass(), ObserverMethod.class, "notify", EventContext.class)) {
            String extensionName = this.extension != null ? "(" + this.extension.toString() + ") ! " : "! ";
            WebBeansConfigurationException e = new WebBeansConfigurationException("ObserverMethod must either implement notify(T) or notify(EventContext) " + extensionName + observerMethod.toString());
            this.webBeansContext.getBeanManagerImpl().getErrorStack().pushError(e);
        }
        if (!(event = new GProcessSyntheticObserverMethod(this.webBeansContext, null, observerMethod, this.extension)).isVetoed()) {
            this.beanManager.fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
            ObserverMethod newObserverMethod = event.getObserverMethod();
            this.webBeansContext.getNotificationManager().addObserver(newObserverMethod);
        }
    }

    @Override
    public <T> AnnotatedType<T> getAnnotatedType(Class<T> type, String id) {
        this.checkState();
        return this.beanManager.getAdditionalAnnotatedType(type, id);
    }

    @Override
    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        this.checkState();
        return this.beanManager.getAnnotatedTypes(type);
    }

    @Override
    public <T> BeanConfigurator<T> addBean() {
        this.checkState();
        BeanConfiguratorImpl beanConfigurator = new BeanConfiguratorImpl(this.webBeansContext);
        this.beanConfigurators.add(beanConfigurator);
        return beanConfigurator;
    }

    @Override
    public <T> ObserverMethodConfigurator<T> addObserverMethod() {
        this.checkState();
        ObserverMethodConfiguratorImpl configurator = new ObserverMethodConfiguratorImpl(this.webBeansContext, this.extension);
        this.observerMethodConfigurators.add(configurator);
        return configurator;
    }

    public void deployConfiguredBeans() {
        this.beanConfigurators.forEach(bc -> this.addBean(bc.getBean()));
        for (ObserverMethodConfiguratorImpl<?> omc : this.observerMethodConfigurators) {
            GProcessSyntheticObserverMethod event;
            ObserverMethod<?> observerMethod = omc.getObserverMethod();
            if (observerMethod == null || (event = new GProcessSyntheticObserverMethod(this.webBeansContext, null, observerMethod, omc.getExtension())).isVetoed()) continue;
            this.beanManager.fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
            ObserverMethod newObserverMethod = event.getObserverMethod();
            this.webBeansContext.getNotificationManager().addObserver(newObserverMethod);
        }
    }
}

