/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.decorator.Delegate;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.component.BeanManagerBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.proxy.OwbInterceptorProxy;

public abstract class AbstractProducer<T>
implements Producer<T> {
    protected Set<InjectionPoint> injectionPoints;
    protected Class<? extends T> proxyClass;
    protected String passivationId;
    protected InterceptorResolutionService.BeanInterceptorInfo interceptorInfo;
    protected InterceptorDecoratorProxyFactory proxyFactory;
    protected Map<Method, List<Interceptor<?>>> methodInterceptors;

    public AbstractProducer() {
        this(Collections.emptySet());
    }

    public AbstractProducer(Set<InjectionPoint> points) {
        this.injectionPoints = points;
    }

    public void defineInterceptorStack(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        if (bean instanceof BeanManagerBean) {
            return;
        }
        this.interceptorInfo = webBeansContext.getInterceptorResolutionService().calculateInterceptorInfo(bean.getTypes(), bean.getQualifiers(), annotatedType, false);
        this.proxyFactory = webBeansContext.getInterceptorDecoratorProxyFactory();
        if (bean instanceof PassivationCapable) {
            PassivationCapable passivationCapable = (PassivationCapable)((Object)bean);
            this.passivationId = passivationCapable.getId();
        }
        this.methodInterceptors = webBeansContext.getInterceptorResolutionService().createMethodInterceptors(this.interceptorInfo);
        this.defineLifecycleInterceptors(bean, annotatedType, webBeansContext);
        if (this.needsProxy()) {
            InterceptorDecoratorProxyFactory pf = webBeansContext.getInterceptorDecoratorProxyFactory();
            ClassLoader classLoader = webBeansContext.getApplicationBoundaryService().getBoundaryClassLoader(annotatedType.getJavaClass());
            Method[] businessMethods = (Method[])this.methodInterceptors.keySet().stream().sorted(Comparator.comparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(Method::toGenericString)).toArray(Method[]::new);
            Method[] nonInterceptedMethods = (Method[])this.interceptorInfo.getNonInterceptedMethods().stream().sorted(Comparator.comparing(Method::getName).thenComparing(Method::getParameterCount).thenComparing(Method::toGenericString)).toArray(Method[]::new);
            this.proxyClass = pf.createProxyClass(bean, classLoader, annotatedType.getJavaClass(), businessMethods, nonInterceptedMethods);
        }
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    public InterceptorResolutionService.BeanInterceptorInfo getInterceptorInfo() {
        return this.interceptorInfo;
    }

    @Override
    public T produce(CreationalContext<T> creationalContext) {
        CreationalContextImpl creationalContextImpl = (CreationalContextImpl)creationalContext;
        Contextual oldContextual = creationalContextImpl.getContextual();
        Map<Interceptor<?>, Object> interceptorInstances = creationalContextImpl.getWebBeansContext().getInterceptorResolutionService().createInterceptorInstances(this.interceptorInfo, creationalContextImpl);
        creationalContextImpl.putContextual(oldContextual);
        Object instance = this.produce(interceptorInstances, creationalContextImpl);
        if (this.hasInterceptorInfo() && !(instance instanceof OwbInterceptorProxy)) {
            instance = creationalContextImpl.getWebBeansContext().getInterceptorResolutionService().createProxiedInstance(instance, creationalContextImpl, creationalContext, this.interceptorInfo, this.proxyClass, this.methodInterceptors, this.passivationId, interceptorInstances, this::isDelegateInjection, this::filterDecorators);
            creationalContextImpl.putContextual(oldContextual);
        }
        return instance;
    }

    protected List<Decorator<?>> filterDecorators(T instance, List<Decorator<?>> decorators) {
        return decorators;
    }

    @Override
    public void dispose(T instance) {
    }

    protected abstract T produce(Map<Interceptor<?>, ?> var1, CreationalContextImpl<T> var2);

    protected InterceptorDecoratorProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected Map<Method, List<Interceptor<?>>> getMethodInterceptors() {
        return this.methodInterceptors;
    }

    protected boolean needsProxy() {
        return !this.methodInterceptors.isEmpty();
    }

    protected boolean hasInterceptorInfo() {
        return this.interceptorInfo != null && this.proxyClass != null;
    }

    protected boolean isDelegateInjection(CreationalContextImpl<?> cc) {
        InjectionPoint ip = cc.getInjectionPoint();
        if (ip == null) {
            return false;
        }
        return ip.getAnnotated().isAnnotationPresent(Delegate.class);
    }

    protected T unwrapProxyInstance(T probableProxyInstance) {
        if (this.proxyFactory != null && probableProxyInstance instanceof OwbInterceptorProxy) {
            return this.proxyFactory.unwrapInstance(probableProxyInstance);
        }
        return probableProxyInstance;
    }

    protected void defineLifecycleInterceptors(Bean<T> bean, AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
    }
}

