/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.portable.AbstractAnnotatedMember;
import org.apache.webbeans.portable.AnnotatedParameterImpl;

public abstract class AbstractAnnotatedCallable<X>
extends AbstractAnnotatedMember<X>
implements AnnotatedCallable<X> {
    private List<AnnotatedParameter<X>> annotatedParameters = new ArrayList<AnnotatedParameter<X>>();

    AbstractAnnotatedCallable(WebBeansContext webBeansContext, Type baseType, Member javaMember, AnnotatedType<X> declaringType) {
        super(webBeansContext, baseType, javaMember, declaringType);
    }

    protected void setAnnotatedParameters(Type[] genericParameterTypes, Annotation[][] parameterAnnotations) {
        int i = 0;
        for (Type genericParameter : genericParameterTypes) {
            AnnotatedParameterImpl parameterImpl = new AnnotatedParameterImpl(this.getWebBeansContext(), genericParameter, this, i);
            parameterImpl.setAnnotations(parameterAnnotations[i]);
            this.addAnnotatedParameter(parameterImpl);
            ++i;
        }
    }

    void addAnnotatedParameter(AnnotatedParameter<X> parameter) {
        this.annotatedParameters.add(parameter);
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return this.annotatedParameters;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(",");
        builder.append("Annotated Parameters : [");
        for (AnnotatedParameter<X> parameter : this.annotatedParameters) {
            builder.append(parameter.toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

