/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.NotificationOptions;
import jakarta.enterprise.event.ObserverException;
import jakarta.enterprise.event.TransactionPhase;
import jakarta.enterprise.inject.spi.AfterDeploymentValidation;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.EventContext;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessBeanAttributes;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionTarget;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessObserverMethod;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.ProcessProducerField;
import jakarta.enterprise.inject.spi.ProcessProducerMethod;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticObserverMethod;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.ContainerEventObserverMethodImpl;
import org.apache.webbeans.event.EventContextImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.ProcessAnnotatedTypeImpl;
import org.apache.webbeans.portable.events.generics.GProcessObserverMethod;
import org.apache.webbeans.portable.events.generics.GenericBeanEvent;
import org.apache.webbeans.portable.events.generics.GenericProducerObserverEvent;
import org.apache.webbeans.portable.events.generics.TwoParametersGenericBeanEvent;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class NotificationManager {
    private final Map<Type, Set<ObserverMethod<?>>> observers = new ConcurrentHashMap();
    private final WebBeansContext webBeansContext;
    private final NotificationOptions defaultNotificationOptions;
    private final ConcurrentMap<Annotation, Boolean> hasContextLifecycleEventObservers = new ConcurrentHashMap<Annotation, Boolean>();
    private final ConcurrentHashMap<Class<?>, Set<ObserverMethod<?>>> observersByRawType = new ConcurrentHashMap();
    private Comparator<? super ObserverMethod<? super Object>> observerMethodComparator = new Comparator<ObserverMethod<? super Object>>(){

        @Override
        public int compare(ObserverMethod<? super Object> o1, ObserverMethod<? super Object> o2) {
            return Integer.compare(o1.getPriority(), o2.getPriority());
        }
    };
    private Map<Type, Set<ObserverMethod<?>>> processAnnotatedTypeObservers;
    private Map<Type, Set<ObserverMethod<?>>> processBeanAttributesObservers;
    private Map<Type, Set<ObserverMethod<?>>> processInjectionTargetObservers;
    private Map<Type, Set<ObserverMethod<?>>> processManagedBeanObservers;
    private Map<Type, Set<ObserverMethod<?>>> processBeanObservers;
    private Map<Type, Set<ObserverMethod<?>>> processInjectionPointObservers;
    private Map<Type, Set<ObserverMethod<?>>> processObserverMethodObservers;
    private Map<Type, Set<ObserverMethod<?>>> processProducerObservers;
    private Map<Type, Set<ObserverMethod<?>>> processProducerFieldObservers;
    private Map<Type, Set<ObserverMethod<?>>> processProducerMethodObservers;
    private Map<Type, Set<ObserverMethod<?>>> processSyntheticBeanObservers;
    private Map<Type, Set<ObserverMethod<?>>> processSyntheticObserverMethodObservers;

    public NotificationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.defaultNotificationOptions = NotificationOptions.ofExecutor(this.getDefaultExecutor());
    }

    private Executor getDefaultExecutor() {
        Executor service = this.webBeansContext.getService(Executor.class);
        return service != null ? service : new CloseableExecutor();
    }

    public void clearCaches() {
        this.observersByRawType.clear();
        this.hasContextLifecycleEventObservers.clear();
        this.processAnnotatedTypeObservers = null;
        this.processBeanAttributesObservers = null;
        this.processInjectionTargetObservers = null;
        this.processManagedBeanObservers = null;
        this.processBeanObservers = null;
        this.processInjectionPointObservers = null;
        this.processObserverMethodObservers = null;
        this.processProducerObservers = null;
        this.processProducerFieldObservers = null;
        this.processProducerMethodObservers = null;
        this.processSyntheticBeanObservers = null;
        this.processSyntheticObserverMethodObservers = null;
    }

    public boolean hasContextLifecycleObserver(Annotation lifecycleEvent) {
        Boolean hasObserver = (Boolean)this.hasContextLifecycleEventObservers.get(lifecycleEvent);
        if (hasObserver == null) {
            hasObserver = Boolean.FALSE;
            for (ObserverMethod<?> observerMethod : this.getObserverMethods()) {
                if (!observerMethod.getObservedQualifiers().contains(lifecycleEvent)) continue;
                hasObserver = Boolean.TRUE;
                break;
            }
            this.hasContextLifecycleEventObservers.putIfAbsent(lifecycleEvent, hasObserver);
        }
        return hasObserver;
    }

    public List<ObserverMethod<?>> getObserverMethods() {
        ArrayList observerMethods = new ArrayList();
        for (Set<ObserverMethod<?>> methods : this.observers.values()) {
            for (ObserverMethod<?> method : methods) {
                observerMethods.add(method);
            }
        }
        return observerMethods;
    }

    public <T> void addObserver(ObserverMethod<T> observer) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(observer.getObservedQualifiers());
        Set set = this.observers.computeIfAbsent(observer.getObservedType(), k -> new HashSet());
        set.add(observer);
    }

    public boolean hasProcessAnnotatedTypeObservers() {
        this.cacheIfNeeded(new ProcessAnnotatedTypeImpl(null, null));
        return !this.processAnnotatedTypeObservers.isEmpty();
    }

    public <T> Collection<ObserverMethod<? super T>> resolveObservers(T event, EventMetadataImpl metadata, boolean isLifecycleEvent) {
        Collection<ObserverMethod<? super T>> observerMethods;
        if (isLifecycleEvent && (observerMethods = this.cacheIfNeeded(event)) != null) {
            return observerMethods;
        }
        Type eventType = metadata.validatedType();
        Collection<ObserverMethod<T>> observersMethods = this.filterByQualifiers(this.filterByType(event, eventType, isLifecycleEvent), metadata.getQualifiers());
        if (isLifecycleEvent && event instanceof ProcessAnnotatedType) {
            observersMethods = this.filterByWithAnnotations(observersMethods, ((ProcessAnnotatedType)event).getAnnotatedType());
        } else if (!isLifecycleEvent && observersMethods.isEmpty()) {
            EventUtil.checkEventBindings(this.webBeansContext, metadata.getQualifiers());
            EventUtil.checkQualifierImplementations(metadata.getQualifiers());
        }
        return observersMethods;
    }

    private <T> Collection<ObserverMethod<?>> cacheIfNeeded(T event) {
        if (event instanceof ProcessAnnotatedType) {
            if (this.processAnnotatedTypeObservers == null) {
                this.processAnnotatedTypeObservers = this.findObservers(ProcessAnnotatedType.class);
            }
            if (this.processAnnotatedTypeObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessManagedBean) {
            if (this.processManagedBeanObservers == null) {
                this.processManagedBeanObservers = this.findObservers(ProcessManagedBean.class);
                if (this.processBeanObservers == null) {
                    this.processBeanObservers = this.findObservers(ProcessBean.class);
                }
                this.processBeanObservers.forEach((k, v) -> this.processManagedBeanObservers.computeIfAbsent((Type)k, it -> new HashSet()).addAll(v));
            }
            if (this.processManagedBeanObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessProducerField) {
            if (this.processProducerFieldObservers == null) {
                this.processProducerFieldObservers = this.findObservers(ProcessProducerField.class);
                if (this.processBeanObservers == null) {
                    this.processBeanObservers = this.findObservers(ProcessBean.class);
                }
                this.processBeanObservers.forEach((k, v) -> this.processProducerFieldObservers.computeIfAbsent((Type)k, it -> new HashSet()).addAll(v));
            }
            if (this.processProducerFieldObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessProducerMethod) {
            if (this.processProducerMethodObservers == null) {
                this.processProducerMethodObservers = this.findObservers(ProcessProducerMethod.class);
                if (this.processBeanObservers == null) {
                    this.processBeanObservers = this.findObservers(ProcessBean.class);
                }
                this.processBeanObservers.forEach((k, v) -> this.processProducerMethodObservers.computeIfAbsent((Type)k, it -> new HashSet()).addAll(v));
            }
            if (this.processProducerMethodObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessSyntheticBean) {
            if (this.processSyntheticBeanObservers == null) {
                this.processSyntheticBeanObservers = this.findObservers(ProcessSyntheticBean.class);
                if (this.processBeanObservers == null) {
                    this.processBeanObservers = this.findObservers(ProcessBean.class);
                }
                this.processBeanObservers.forEach((k, v) -> this.processSyntheticBeanObservers.computeIfAbsent((Type)k, it -> new HashSet()).addAll(v));
            }
            if (this.processSyntheticBeanObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessSyntheticObserverMethod) {
            if (this.processSyntheticObserverMethodObservers == null) {
                this.processSyntheticObserverMethodObservers = this.findObservers(ProcessSyntheticObserverMethod.class);
                if (this.processObserverMethodObservers == null) {
                    this.processObserverMethodObservers = this.findObservers(ProcessObserverMethod.class);
                }
                this.processObserverMethodObservers.forEach((k, v) -> this.processSyntheticObserverMethodObservers.computeIfAbsent((Type)k, it -> new HashSet()).addAll(v));
            }
            if (this.processSyntheticObserverMethodObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessBean) {
            if (this.processBeanObservers == null) {
                this.processBeanObservers = this.findObservers(ProcessBean.class);
            }
            if (this.processBeanObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessBeanAttributes) {
            if (this.processBeanAttributesObservers == null) {
                this.processBeanAttributesObservers = this.findObservers(ProcessBeanAttributes.class);
            }
            if (this.processBeanAttributesObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessInjectionTarget) {
            if (this.processInjectionTargetObservers == null) {
                this.processInjectionTargetObservers = this.findObservers(ProcessInjectionTarget.class);
            }
            if (this.processInjectionTargetObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessInjectionPoint) {
            if (this.processInjectionPointObservers == null) {
                this.processInjectionPointObservers = this.findObservers(ProcessInjectionPoint.class);
            }
            if (this.processInjectionPointObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessObserverMethod) {
            if (this.processObserverMethodObservers == null) {
                this.processObserverMethodObservers = this.findObservers(ProcessObserverMethod.class);
            }
            if (this.processObserverMethodObservers.isEmpty()) {
                return Collections.emptyList();
            }
        } else if (event instanceof ProcessProducer) {
            if (this.processProducerObservers == null) {
                this.processProducerObservers = this.findObservers(ProcessProducer.class);
            }
            if (this.processProducerObservers.isEmpty()) {
                return Collections.emptyList();
            }
        }
        return null;
    }

    private <T> Collection<ObserverMethod<? super T>> filterByWithAnnotations(Collection<ObserverMethod<? super T>> observersMethods, AnnotatedType annotatedType) {
        ArrayList<ObserverMethod<T>> observerMethodsWithAnnotations = new ArrayList<ObserverMethod<T>>();
        for (ObserverMethod<T> observerMethod : observersMethods) {
            Class[] withAnnotations = ((ContainerEventObserverMethodImpl)observerMethod).getWithAnnotations();
            if (withAnnotations != null && withAnnotations.length > 0) {
                if (!this.annotatedTypeHasAnnotations(annotatedType, withAnnotations)) continue;
                observerMethodsWithAnnotations.add(observerMethod);
                continue;
            }
            observerMethodsWithAnnotations.add(observerMethod);
        }
        return observerMethodsWithAnnotations;
    }

    private boolean annotatedTypeHasAnnotations(AnnotatedType annotatedType, Class<? extends Annotation>[] withAnnotations) {
        if (this.hasAnnotation(annotatedType.getAnnotations(), withAnnotations)) {
            return true;
        }
        Set fields = annotatedType.getFields();
        for (AnnotatedField annotatedField : fields) {
            if (!this.hasAnnotation(annotatedField.getAnnotations(), withAnnotations)) continue;
            return true;
        }
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (this.hasAnnotation(annotatedMethod.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        Set annotatedConstructors = annotatedType.getConstructors();
        for (AnnotatedConstructor annotatedConstructor : annotatedConstructors) {
            if (this.hasAnnotation(annotatedConstructor.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnnotation(Set<Annotation> annotations, Class<? extends Annotation>[] withAnnotations) {
        for (Class<? extends Annotation> withAnnotation : withAnnotations) {
            for (Annotation annotation : annotations) {
                if (withAnnotation.isAssignableFrom(annotation.annotationType())) {
                    return true;
                }
                for (Annotation meta : annotation.annotationType().getAnnotations()) {
                    if (!withAnnotation.isAssignableFrom(meta.annotationType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private <T> Set<ObserverMethod<? super T>> filterByType(T event, Type declaredEventType, boolean isLifecycleEvent) {
        Set<ObserverMethod<? super T>> rawTypeObservers;
        if (isLifecycleEvent) {
            return this.filterByExtensionEventType(event, declaredEventType);
        }
        Class<?> eventClass = event.getClass();
        boolean isRawEvent = declaredEventType instanceof Class;
        if (isRawEvent && (rawTypeObservers = this.observersByRawType.get(eventClass)) != null) {
            return rawTypeObservers;
        }
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        Set<Type> eventTypes = GenericsUtil.getTypeClosure(declaredEventType, eventClass);
        if (GenericsUtil.containTypeVariable(eventTypes)) {
            throw new IllegalArgumentException("event type may not contain unbound type variable: " + eventTypes);
        }
        block0: for (Map.Entry<Type, Set<ObserverMethod<?>>> observerEntry : this.observers.entrySet()) {
            Type observedType = observerEntry.getKey();
            for (Type eventType : eventTypes) {
                if ((!ParameterizedType.class.isInstance(eventType) || !Class.class.isInstance(observedType) || !GenericsUtil.isAssignableFrom(true, false, observedType, ((ParameterizedType)ParameterizedType.class.cast(eventType)).getRawType(), new HashMap<Type, Integer>())) && !GenericsUtil.isAssignableFrom(true, false, observedType, eventType, new HashMap<Type, Integer>())) continue;
                Set<ObserverMethod<?>> observerMethods = observerEntry.getValue();
                for (ObserverMethod<?> observerMethod : observerMethods) {
                    matching.add(observerMethod);
                }
                continue block0;
            }
        }
        if (isRawEvent) {
            this.observersByRawType.putIfAbsent(eventClass, matching);
        }
        return matching;
    }

    private <T> Set<ObserverMethod<? super T>> filterByExtensionEventType(T event, Type eventType) {
        Class<?> eventClass = ClassUtil.getClazz(eventType);
        HashSet<ObserverMethod<? super T>> matching = new HashSet<ObserverMethod<? super T>>();
        Map<Type, Set<ObserverMethod<?>>> sourceMap = event instanceof ProcessAnnotatedType ? this.processAnnotatedTypeObservers : (event instanceof ProcessSyntheticObserverMethod ? this.processSyntheticObserverMethodObservers : (event instanceof ProcessObserverMethod ? this.processObserverMethodObservers : (event instanceof ProcessProducerField ? this.processProducerFieldObservers : (event instanceof ProcessProducerMethod ? this.processProducerMethodObservers : (event instanceof ProcessSyntheticBean ? this.processSyntheticBeanObservers : (event instanceof ProcessProducer ? this.processProducerObservers : (event instanceof ProcessManagedBean ? this.processManagedBeanObservers : (event instanceof ProcessBean ? this.processBeanObservers : (event instanceof ProcessBeanAttributes ? this.processBeanAttributesObservers : (event instanceof ProcessInjectionTarget ? this.processInjectionTargetObservers : (event instanceof ProcessInjectionPoint ? this.processInjectionPointObservers : this.observers)))))))))));
        Set<Type> keySet = sourceMap.keySet();
        for (Type type : keySet) {
            Class<?> beanClass;
            Object genericBeanEvent;
            Class<?> observerClass = ClassUtil.getClazz(type);
            if (observerClass == null || !observerClass.isAssignableFrom(eventClass)) continue;
            if (WebBeansUtil.isExtensionBeanEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionBeanEventType(observerClass)) continue;
                genericBeanEvent = (GenericBeanEvent)event;
                beanClass = genericBeanEvent.getBeanClassFor(observerClass);
                if (ClassUtil.isParametrizedType(type)) {
                    Type secondParam = null;
                    if (TwoParametersGenericBeanEvent.class.isInstance(event)) {
                        secondParam = ((TwoParametersGenericBeanEvent)TwoParametersGenericBeanEvent.class.cast(event)).getInjectionType();
                    }
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, secondParam);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (WebBeansUtil.isExtensionProducerOrObserverEventType(eventType)) {
                genericBeanEvent = (GenericProducerObserverEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                Class<?> producerOrObserverReturnClass = genericBeanEvent.getProducerOrObserverType();
                if (WebBeansUtil.isDefaultExtensionProducerOrObserverEventType(observerClass)) {
                    boolean processProducerEvent = false;
                    if (observerClass.equals(ProcessProducer.class)) {
                        processProducerEvent = true;
                    }
                    if (ClassUtil.isParametrizedType(type)) {
                        this.addToMatchingWithParametrizedForProducers(processProducerEvent, type, beanClass, producerOrObserverReturnClass, matching);
                        continue;
                    }
                    this.addToMatching(type, matching);
                    continue;
                }
                if (!observerClass.isAssignableFrom(eventClass)) continue;
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, null);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (!observerClass.isAssignableFrom(eventClass)) continue;
            this.addToMatching(type, matching);
        }
        return matching;
    }

    private boolean checkEventTypeParameterForExtensions(Type beanClass, Type observerTypeActualArg) {
        if (ClassUtil.isTypeVariable(observerTypeActualArg)) {
            TypeVariable tv = (TypeVariable)observerTypeActualArg;
            Type tvBound = tv.getBounds()[0];
            if (tvBound instanceof Class) {
                Class clazzTvBound = (Class)tvBound;
                if (Class.class.isInstance(beanClass) && clazzTvBound.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            }
        } else {
            if (ClassUtil.isWildCardType(observerTypeActualArg)) {
                return ClassUtil.checkRequiredTypeIsWildCard(beanClass, observerTypeActualArg);
            }
            if (observerTypeActualArg instanceof Class) {
                Class observerClass = (Class)observerTypeActualArg;
                if (Class.class.isInstance(beanClass) && observerClass.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            } else if (observerTypeActualArg instanceof ParameterizedType) {
                return GenericsUtil.isAssignableFrom(false, true, observerTypeActualArg, beanClass, new HashMap<Type, Integer>());
            }
        }
        return false;
    }

    private <T> void addToMatching(Type type, Set<ObserverMethod<? super T>> matching) {
        Set<ObserverMethod<?>> wrappers = this.observers.get(type);
        for (ObserverMethod<?> wrapper : wrappers) {
            matching.add(wrapper);
        }
    }

    private <T> void addToMatchingWithParametrizedForBeans(Type type, Set<ObserverMethod<? super T>> matching, Class<?> beanClass, Type secondParam) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else if (this.checkEventTypeParameterForExtensions(beanClass, actualArgs[0]) && (secondParam == null || actualArgs.length == 1 || this.checkEventTypeParameterForExtensions(secondParam, actualArgs[1]) || GenericsUtil.isAssignableFrom(true, false, actualArgs[1], secondParam, new HashMap<Type, Integer>()))) {
            this.addToMatching(type, matching);
        }
    }

    private <T> void addToMatchingWithParametrizedForProducers(boolean processProducer, Type type, Class<?> beanClass, Class<?> producerOrObserverReturnClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else {
            Type beanClassArg = actualArgs[1];
            Type returnClassArg = actualArgs[0];
            if (processProducer) {
                beanClassArg = actualArgs[0];
                returnClassArg = actualArgs[1];
            }
            if (this.checkEventTypeParameterForExtensions(beanClass, beanClassArg) && this.checkEventTypeParameterForExtensions(producerOrObserverReturnClass, returnClassArg)) {
                this.addToMatching(type, matching);
            }
        }
    }

    private <T> Collection<ObserverMethod<? super T>> filterByQualifiers(Collection<ObserverMethod<? super T>> observers, Set<Annotation> eventQualifiers) {
        ArrayList<ObserverMethod<T>> matching = new ArrayList<ObserverMethod<T>>(observers.size());
        block0: for (ObserverMethod<T> ob : observers) {
            Set<Annotation> qualifiers = ob.getObservedQualifiers();
            if (qualifiers.size() > eventQualifiers.size()) continue;
            for (Annotation qualifier : qualifiers) {
                boolean found = false;
                for (Annotation inList : eventQualifiers) {
                    if (!AnnotationUtil.isCdiAnnotationEqual(inList, qualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            matching.add(ob);
        }
        return matching;
    }

    public NotificationOptions getDefaultNotificationOptions() {
        return this.defaultNotificationOptions;
    }

    public <T> CompletionStage<T> fireEvent(Object event, EventMetadataImpl metadata, boolean isLifecycleEvent, NotificationOptions notificationOptions) {
        boolean async;
        boolean bl = async = notificationOptions != null;
        if (!isLifecycleEvent && this.webBeansContext.getWebBeansUtil().isContainerEventType(event)) {
            throw new IllegalArgumentException("Firing container events is forbidden");
        }
        return this.doFireEvent(event, metadata, isLifecycleEvent, notificationOptions, async, new ArrayList<ObserverMethod<? super Object>>(this.resolveObservers(event, metadata, isLifecycleEvent)));
    }

    public <T> CompletionStage<T> doFireEvent(Object event, EventMetadataImpl metadata, boolean isLifecycleEvent, NotificationOptions notificationOptions, boolean async, List<ObserverMethod<? super Object>> observerMethods) {
        this.prepareObserverListForFire(isLifecycleEvent, async, observerMethods);
        if (observerMethods.isEmpty()) {
            if (async) {
                return CompletableFuture.completedFuture(event);
            }
            return null;
        }
        EventContextImpl<Object> context = new EventContextImpl<Object>(event, metadata);
        if (async) {
            return this.doFireAsync(context, isLifecycleEvent, notificationOptions, observerMethods);
        }
        this.doFireSync(context, isLifecycleEvent, observerMethods);
        return null;
    }

    public <T> CompletionStage<T> doFireAsync(EventContext<?> context, boolean isLifecycleEvent, NotificationOptions notificationOptions, List<ObserverMethod<? super Object>> observerMethods) {
        ArrayList<CompletableFuture<Void>> completableFutures = new ArrayList<CompletableFuture<Void>>();
        for (ObserverMethod<? super Object> observer : observerMethods) {
            try {
                TransactionPhase phase = observer.getTransactionPhase();
                if (phase == null || phase == TransactionPhase.IN_PROGRESS) {
                    completableFutures.add(this.invokeObserverMethodAsync(context, observer, notificationOptions));
                    continue;
                }
                throw new WebBeansConfigurationException("Async Observer Methods can only use TransactionPhase.IN_PROGRESS!");
            }
            catch (WebBeansException e) {
                return this.onWebBeansException(context.getEvent(), isLifecycleEvent, e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
        return this.complete(completableFutures, context.getEvent());
    }

    public void doFireSync(EventContext<?> context, boolean isLifecycleEvent, List<ObserverMethod<? super Object>> observerMethods) {
        if (observerMethods.isEmpty()) {
            return;
        }
        for (ObserverMethod<? super Object> observer : observerMethods) {
            try {
                TransactionPhase phase = observer.getTransactionPhase();
                if (phase == null || phase == TransactionPhase.IN_PROGRESS) {
                    this.invokeObserverMethod(context, observer);
                    continue;
                }
                TransactionService transactionService = this.webBeansContext.getTransactionService();
                if (transactionService != null) {
                    transactionService.registerTransactionSynchronization(phase, observer, context.getEvent());
                    continue;
                }
                this.invokeObserverMethod(context, observer);
            }
            catch (WebBeansException e) {
                this.onWebBeansException(context.getEvent(), isLifecycleEvent, e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
    }

    public void prepareObserverListForFire(boolean isLifecycleEvent, boolean async, List<ObserverMethod<? super Object>> observerMethods) {
        if (!isLifecycleEvent) {
            observerMethods.removeIf(observerMethod -> async != observerMethod.isAsync());
        } else {
            observerMethods.removeIf(observer -> !Extension.class.isAssignableFrom(observer.getBeanClass()));
        }
        if (observerMethods.size() > 1) {
            observerMethods.sort(this.observerMethodComparator);
        }
    }

    private <T> CompletionStage<T> onWebBeansException(Object event, boolean isLifecycleEvent, WebBeansException e) {
        Throwable exc = e.getCause();
        if (exc instanceof InvocationTargetException) {
            InvocationTargetException invt = (InvocationTargetException)exc;
            exc = invt.getCause();
        }
        if (isLifecycleEvent) {
            if (event instanceof AfterDeploymentValidation) {
                throw new WebBeansDeploymentException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
            }
            throw new WebBeansConfigurationException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
        }
        if (!RuntimeException.class.isAssignableFrom(exc.getClass())) {
            throw new ObserverException(WebBeansLoggerFacade.getTokenString("EXCEPT_0008") + event.getClass().getName(), e);
        }
        RuntimeException rte = (RuntimeException)exc;
        throw rte;
    }

    private <T> CompletableFuture<T> complete(List<CompletableFuture<Void>> completableFutures, T event) {
        if (completableFutures == null) {
            return null;
        }
        if (completableFutures.isEmpty()) {
            return CompletableFuture.completedFuture(event);
        }
        CDICompletionFuture future = new CDICompletionFuture(event, completableFutures.size());
        completableFutures.forEach(f -> f.handle((t, e) -> {
            future.addResult((Throwable)e);
            return null;
        }));
        return future;
    }

    private CompletableFuture invokeObserverMethodAsync(EventContext<?> context, ObserverMethod<? super Object> observer, NotificationOptions notificationOptions) {
        CompletableFuture future = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                this.runAsync(context, observer);
                future.complete(null);
            }
            catch (WebBeansException wbe) {
                future.completeExceptionally(wbe.getCause());
            }
        }, notificationOptions.getExecutor() == null ? this.defaultNotificationOptions.getExecutor() : notificationOptions.getExecutor());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsync(EventContext<?> context, ObserverMethod<? super Object> observer) {
        ContextsService contextsService = this.webBeansContext.getContextsService();
        contextsService.startContext(RequestScoped.class, null);
        try {
            this.invokeObserverMethod(context, observer);
        }
        finally {
            contextsService.endContext(RequestScoped.class, null);
        }
    }

    private void invokeObserverMethod(EventContext context, ObserverMethod<?> observer) {
        observer.notify(context);
    }

    public <T> ObserverMethod<?> getObservableMethodForAnnotatedMethod(AnnotatedMethod<?> annotatedMethod, AnnotatedParameter<?> annotatedParameter, AbstractOwbBean<T> ownerBean, boolean checkContainerEvents) {
        Asserts.assertNotNull(annotatedParameter, "annotatedParameter");
        if (checkContainerEvents && this.isContainerEvent(annotatedParameter)) {
            ContainerEventObserverMethodImpl observer = new ContainerEventObserverMethodImpl(ownerBean, annotatedMethod, annotatedParameter);
            this.addObserver(observer);
            return observer;
        }
        ObserverMethodImpl observer = new ObserverMethodImpl(ownerBean, annotatedMethod, annotatedParameter);
        GProcessObserverMethod event = new GProcessObserverMethod(this.webBeansContext, annotatedMethod, (ObserverMethod<?>)observer);
        this.webBeansContext.getBeanManagerImpl().fireEvent((Object)event, true, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        this.webBeansContext.getWebBeansUtil().inspectDefinitionErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
        if (event.isVetoed()) {
            event.setStarted();
            return null;
        }
        this.addObserver(event.getObserverMethod());
        event.setStarted();
        return observer;
    }

    public boolean isContainerEvent(AnnotatedParameter<?> annotatedParameter) {
        AnnotatedCallable<?> method = annotatedParameter.getDeclaringCallable();
        if (!AnnotatedMethod.class.isInstance(method) || method.getParameters().isEmpty()) {
            return false;
        }
        Class<?> paramType = ((AnnotatedMethod)AnnotatedMethod.class.cast(method)).getJavaMember().getParameterTypes()[0];
        return this.webBeansContext.getWebBeansUtil().isContainerEventType(paramType);
    }

    private Map<Type, Set<ObserverMethod<?>>> findObservers(Class<?> type) {
        return this.observers.entrySet().stream().filter(it -> {
            Class<?> keyType = ClassUtil.getClass((Type)it.getKey());
            return type.isAssignableFrom(keyType);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static final class CloseableExecutor
    implements Executor,
    Closeable {
        private final Collection<Runnable> tracker = new CopyOnWriteArrayList<Runnable>();
        private volatile boolean reject;

        private CloseableExecutor() {
        }

        @Override
        public void close() throws IOException {
            this.reject = true;
            this.tracker.forEach(r -> {
                try {
                    r.run();
                }
                catch (RuntimeException re) {
                    WebBeansLoggerFacade.getLogger(NotificationManager.class).warning(re.getMessage());
                }
            });
        }

        @Override
        public void execute(Runnable command) {
            if (this.reject) {
                throw new RejectedExecutionException("CDI executor is shutdown");
            }
            this.tracker.add(command);
            ForkJoinPool.commonPool().execute(() -> {
                try {
                    command.run();
                }
                finally {
                    this.tracker.remove(command);
                }
            });
        }
    }

    private static final class CDICompletionFuture<T>
    extends CompletableFuture<T> {
        private final T event;
        private final AtomicInteger counter;
        private AtomicReference<CompletionException> error = new AtomicReference();

        private CDICompletionFuture(T event, int total) {
            this.event = event;
            this.counter = new AtomicInteger(total);
        }

        CDICompletionFuture<T> addResult(Throwable t) {
            if (t != null) {
                if (this.error.get() == null) {
                    this.error.compareAndSet(null, new CompletionException(t));
                }
                this.error.get().addSuppressed(t);
            }
            if (this.counter.decrementAndGet() == 0) {
                if (this.error.get() != null) {
                    this.completeExceptionally(this.error.get());
                } else {
                    this.complete(this.event);
                }
            }
            return this;
        }
    }
}

