/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.Asserts;

public class DefaultSingletonService
implements SingletonService<WebBeansContext> {
    private final Map<ClassLoader, WebBeansContext> singletonMap = new WeakHashMap<ClassLoader, WebBeansContext>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WebBeansContext get(Object key) {
        this.assertClassLoaderKey(key);
        ClassLoader classLoader = (ClassLoader)key;
        Map<ClassLoader, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            WebBeansContext webBeansContext = this.singletonMap.get(classLoader);
            if (webBeansContext == null) {
                webBeansContext = new WebBeansContext();
                this.singletonMap.put(classLoader, webBeansContext);
            }
            return webBeansContext;
        }
    }

    public void register(ClassLoader key, WebBeansContext context) {
        if (this.singletonMap.containsKey(key)) {
            throw new IllegalArgumentException(key + " is already registered");
        }
        this.singletonMap.putIfAbsent(key, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull(classLoader, "classloader");
        Map<ClassLoader, WebBeansContext> map = this.singletonMap;
        synchronized (map) {
            this.singletonMap.remove(classLoader);
        }
    }

    @Override
    public void clear(Object classLoader) {
        this.assertClassLoaderKey(classLoader);
        this.clearInstances((ClassLoader)classLoader);
    }

    private void assertClassLoaderKey(Object key) {
        if (!(key instanceof ClassLoader)) {
            throw new IllegalArgumentException("Key instance must be ClassLoader for using DefaultSingletonService");
        }
    }

    public boolean exists(Object key) {
        return ClassLoader.class.isInstance(key) && this.singletonMap.containsKey(key);
    }
}

