/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansDeploymentException;

public final class SerializableBean<T>
implements Bean<T>,
PassivationCapable,
Serializable {
    private static final long serialVersionUID = -8141263188006177021L;
    private Bean<T> bean;

    public Bean<T> getBean() {
        return this.bean;
    }

    SerializableBean(Bean<T> bean) {
        this.bean = bean;
    }

    @Override
    public Set<Type> getTypes() {
        return this.bean.getTypes();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.bean.getQualifiers();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.bean.getScope();
    }

    @Override
    public String getName() {
        return this.bean.getName();
    }

    @Override
    public boolean isNullable() {
        return this.bean.isNullable();
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.bean.getInjectionPoints();
    }

    @Override
    public Class<?> getBeanClass() {
        return this.bean.getBeanClass();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.bean.getStereotypes();
    }

    @Override
    public boolean isAlternative() {
        return this.bean.isAlternative();
    }

    @Override
    public T create(CreationalContext<T> tCreationalContext) {
        return this.bean.create(tCreationalContext);
    }

    @Override
    public void destroy(T instance, CreationalContext<T> tCreationalContext) {
        this.bean.destroy(instance, tCreationalContext);
    }

    @Override
    public String getId() {
        return ((OwbBean)this.bean).getId();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        String id = this.getId();
        if (id == null) {
            throw new NotSerializableException();
        }
        s.writeObject(id);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String id = (String)s.readObject();
        Bean<Object> b = WebBeansContext.currentInstance().getBeanManagerImpl().getPassivationCapableBean(id);
        if (b == null) {
            throw new WebBeansDeploymentException("cannot deserialize Bean with PassivationCapable id=" + id);
        }
        if (b instanceof SerializableBean) {
            b = ((SerializableBean)b).getBean();
        }
        this.bean = b;
    }

    public boolean equals(Object other) {
        if (other instanceof SerializableBean) {
            return this.bean.equals(((SerializableBean)other).getBean());
        }
        return this.bean.equals(other) || super.equals(other);
    }

    public int hashCode() {
        return this.bean.hashCode();
    }
}

