/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.AnnotatedTypeConfiguratorImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.AnnotatedTypeImpl;
import org.apache.webbeans.proxy.InterceptorDecoratorProxyFactory;
import org.apache.webbeans.util.WebBeansUtil;

public class InterceptionFactoryImpl<T>
implements InterceptionFactory<T> {
    private final CreationalContextImpl<T> creationalContext;
    private final AnnotatedTypeConfiguratorImpl<T> configurator;
    private final Set<Annotation> qualifiers;
    private final WebBeansContext context;
    private boolean ignoreFinals;
    private volatile boolean called;

    public InterceptionFactoryImpl(WebBeansContext context, AnnotatedType<T> at, Set<Annotation> qualifiers, CreationalContextImpl<T> cc) {
        this.context = context;
        this.configurator = new AnnotatedTypeConfiguratorImpl<T>(context, at);
        this.qualifiers = qualifiers;
        this.creationalContext = cc;
    }

    @Override
    public InterceptionFactory<T> ignoreFinalMethods() {
        this.ignoreFinals = true;
        return this;
    }

    @Override
    public AnnotatedTypeConfigurator<T> configure() {
        return this.configurator;
    }

    @Override
    public T createInterceptedInstance(T originalInstance) {
        this.check();
        ClassLoader classLoader = originalInstance.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = WebBeansUtil.getCurrentClassLoader();
        }
        InterceptorDecoratorProxyFactory factory = this.context.getInterceptorDecoratorProxyFactory();
        AnnotatedTypeImpl<T> newAnnotatedType = this.configurator.getNewAnnotatedType();
        InterceptorResolutionService.BeanInterceptorInfo interceptorInfo = this.context.getInterceptorResolutionService().calculateInterceptorInfo(newAnnotatedType.getTypeClosure(), this.qualifiers, newAnnotatedType, !this.ignoreFinals);
        Class<T> subClass = factory.getCachedProxyClass(interceptorInfo, newAnnotatedType, classLoader);
        Map<Interceptor<?>, Object> interceptorInstances = this.context.getInterceptorResolutionService().createInterceptorInstances(interceptorInfo, this.creationalContext);
        Map<Method, List<Interceptor<?>>> methodInterceptors = this.context.getInterceptorResolutionService().createMethodInterceptors(interceptorInfo);
        String passivationId = InterceptionFactory.class.getName() + ">>" + newAnnotatedType.toString();
        return (T)this.context.getInterceptorResolutionService().createProxiedInstance(originalInstance, this.creationalContext, this.creationalContext, interceptorInfo, subClass, methodInterceptors, passivationId, interceptorInstances, c -> false, (a, d) -> d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        boolean ok = false;
        if (!this.called) {
            InterceptionFactoryImpl interceptionFactoryImpl = this;
            synchronized (interceptionFactoryImpl) {
                if (!this.called) {
                    this.called = true;
                    ok = true;
                }
            }
        }
        if (!ok) {
            throw new IllegalStateException("createInterceptedInstance() can be called only once");
        }
    }
}

