/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.configurator;

import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.configurator.InjectionPointConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.inject.impl.InjectionPointImpl;

public class InjectionPointConfiguratorImpl
implements InjectionPointConfigurator {
    private Bean<?> ownerBean;
    private Type type;
    private Set<Annotation> qualifiers = new HashSet<Annotation>();
    private Annotated annotated;
    private Member member;
    private boolean isDelegate;
    private boolean isTransient;

    public InjectionPointConfiguratorImpl(InjectionPoint originalInjectionPoint) {
        this.ownerBean = originalInjectionPoint.getBean();
        this.type = originalInjectionPoint.getType();
        this.qualifiers.addAll(originalInjectionPoint.getQualifiers());
        this.annotated = originalInjectionPoint.getAnnotated();
        this.member = originalInjectionPoint.getMember();
        this.isDelegate = originalInjectionPoint.isDelegate();
        this.isTransient = originalInjectionPoint.isTransient();
    }

    @Override
    public InjectionPointConfigurator type(Type requiredType) {
        this.type = requiredType;
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifier(Annotation qualifier) {
        this.qualifiers.add(qualifier);
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifiers(Annotation ... qualifiers) {
        for (Annotation qualifier : qualifiers) {
            this.qualifiers.add(qualifier);
        }
        return this;
    }

    @Override
    public InjectionPointConfigurator addQualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.addAll(qualifiers);
        return this;
    }

    @Override
    public InjectionPointConfigurator qualifiers(Annotation ... qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InjectionPointConfigurator qualifiers(Set<Annotation> qualifiers) {
        this.qualifiers.clear();
        this.addQualifiers(qualifiers);
        return this;
    }

    @Override
    public InjectionPointConfigurator delegate(boolean delegate) {
        this.isDelegate = delegate;
        return this;
    }

    @Override
    public InjectionPointConfigurator transientField(boolean trans) {
        this.isTransient = trans;
        return this;
    }

    public InjectionPoint getInjectionPoint() {
        if (this.qualifiers.isEmpty()) {
            this.qualifiers.add(DefaultLiteral.INSTANCE);
        } else if (this.qualifiers.size() > 1) {
            this.qualifiers.remove(DefaultLiteral.INSTANCE);
        }
        return new InjectionPointImpl(this.ownerBean, this.type, this.qualifiers, this.annotated, this.member, this.isDelegate, this.isTransient);
    }
}

