/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ProducerFieldBeanBuilder;
import org.apache.webbeans.component.creation.ResourceBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.portable.events.ProcessBeanAttributesImpl;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.WebBeansUtil;

public class ProducerFieldBeansBuilder<T> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;

    public ProducerFieldBeansBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(annotatedType, "annotated type");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
    }

    public Set<ProducerFieldBean<?>> defineProducerFields(InjectionTargetBean<T> bean) {
        HashSet producerBeans = new HashSet();
        Set<AnnotatedField<T>> annotatedFields = this.annotatedType.getFields();
        for (AnnotatedField<T> annotatedField : annotatedFields) {
            if (!annotatedField.isAnnotationPresent(Produces.class) || !annotatedField.getJavaMember().getDeclaringClass().equals(this.annotatedType.getJavaClass())) continue;
            Annotation[] anns = AnnotationUtil.asArray(annotatedField.getAnnotations());
            Field field = annotatedField.getJavaMember();
            Annotation resourceAnnotation = AnnotationUtil.hasOwbInjectableResource(anns);
            if (resourceAnnotation != null) {
                ResourceReference resourceRef = new ResourceReference(this.annotatedType.getJavaClass(), field.getName(), field.getType(), resourceAnnotation);
                if (annotatedField.isAnnotationPresent(Named.class)) {
                    throw new WebBeansConfigurationException("Resource producer annotated field : " + annotatedField + " can not define EL name");
                }
                ProcessBeanAttributesImpl<T> processBeanAttributes = this.fireProcessBeanAttributes(annotatedField);
                if (processBeanAttributes == null) continue;
                ResourceBeanBuilder resourceBeanCreator = new ResourceBeanBuilder(bean, resourceRef, annotatedField, processBeanAttributes.getAttributes());
                ResourceBean resourceBean = (ResourceBean)resourceBeanCreator.getBean();
                resourceBean.setProducerField(field);
                producerBeans.add(resourceBean);
                this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, resourceBean, anns);
                continue;
            }
            ProcessBeanAttributesImpl<T> processBeanAttributes = this.fireProcessBeanAttributes(annotatedField);
            ProducerFieldBeanBuilder producerFieldBeanCreator = new ProducerFieldBeanBuilder(bean, annotatedField, processBeanAttributes.getAttributes());
            Object producerFieldBean = producerFieldBeanCreator.getBean();
            UnproxyableResolutionException lazyException = this.webBeansContext.getDeploymentValidationService().validateProxyable((OwbBean<?>)producerFieldBean, processBeanAttributes.isIgnoreFinalMethods());
            if (lazyException != null) {
                throw lazyException;
            }
            producerFieldBeanCreator.validate();
            ((ProducerFieldBean)producerFieldBean).setProducerField(field);
            this.webBeansContext.getWebBeansUtil().setBeanEnableFlagForProducerBean(bean, (AbstractProducerBean<?>)producerFieldBean, anns);
            WebBeansUtil.checkProducerGenericType(producerFieldBean, annotatedField.getJavaMember());
            producerBeans.add((ProducerFieldBean<?>)producerFieldBean);
        }
        return producerBeans;
    }

    private ProcessBeanAttributesImpl<T> fireProcessBeanAttributes(AnnotatedField<? super T> annotatedField) {
        return this.webBeansContext.getWebBeansUtil().fireProcessBeanAttributes(annotatedField, annotatedField.getJavaMember().getType(), BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(annotatedField).build());
    }
}

