/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.webbeans.component.InterceptorBean;
import org.apache.webbeans.component.creation.AbstractBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public abstract class InterceptorBeanBuilder<T, B extends InterceptorBean<T>>
extends AbstractBeanBuilder {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributes<T> beanAttributes;
    private final OpenWebBeansEjbLCAPlugin ejbPlugin;
    private final Class<? extends Annotation> prePassivateClass;
    private final Class<? extends Annotation> postActivateClass;
    protected Map<InterceptionType, Method[]> interceptionMethods;

    protected InterceptorBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributes<T> beanAttributes) {
        Asserts.assertNotNull(webBeansContext, "WebBeansContetx");
        Asserts.assertNotNull(annotatedType, "annotated type");
        Asserts.assertNotNull(beanAttributes, "beanAttributes");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
        this.ejbPlugin = webBeansContext.getPluginLoader().getEjbLCAPlugin();
        if (this.ejbPlugin != null) {
            this.prePassivateClass = this.ejbPlugin.getPrePassivateClass();
            this.postActivateClass = this.ejbPlugin.getPostActivateClass();
        } else {
            this.prePassivateClass = null;
            this.postActivateClass = null;
        }
    }

    public abstract boolean isInterceptorEnabled();

    protected void checkInterceptorConditions() {
        Set<AnnotatedMethod<T>> methods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType);
        for (AnnotatedMethod<T> method : methods) {
            for (AnnotatedParameter parameter : method.getParameters()) {
                if (!parameter.isAnnotationPresent(Produces.class)) continue;
                throw new WebBeansConfigurationException("Interceptor class : " + this.annotatedType.getJavaClass() + " can not have producer methods but it has one with name : " + method.getJavaMember().getName());
            }
        }
    }

    public boolean defineInterceptorMethods() {
        List<Class> classHierarchy = this.webBeansContext.getInterceptorUtil().getReverseClassHierarchy(this.annotatedType.getJavaClass());
        ArrayList<Method> aroundInvokeMethod = null;
        ArrayList<AnnotatedMethod> postConstructMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> preDestroyMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> aroundTimeoutMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> aroundConstructMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> prePassivateMethods = new ArrayList<AnnotatedMethod>();
        ArrayList<AnnotatedMethod> postActivateMethods = new ArrayList<AnnotatedMethod>();
        boolean interceptorFound = false;
        Set<AnnotatedMethod<T>> methods = this.webBeansContext.getAnnotatedElementFactory().getFilteredAnnotatedMethods(this.annotatedType);
        for (Class clazz : classHierarchy) {
            for (AnnotatedMethod<Annotation> annotatedMethod : methods) {
                int arouncConstructCount = 0;
                if (clazz != annotatedMethod.getJavaMember().getDeclaringClass()) continue;
                if (annotatedMethod.getAnnotation(AroundConstruct.class) != null) {
                    if (arouncConstructCount > 0) {
                        throw new WebBeansConfigurationException("only one AroundConstruct allowed per Interceptor");
                    }
                    ++arouncConstructCount;
                    aroundConstructMethods.add(annotatedMethod);
                }
                if (annotatedMethod.getAnnotation(AroundInvoke.class) != null) {
                    if (aroundInvokeMethod != null) {
                        for (Method ai : aroundInvokeMethod) {
                            if (ai.getDeclaringClass() != annotatedMethod.getJavaMember().getDeclaringClass()) continue;
                            throw new WebBeansConfigurationException("only one AroundInvoke allowed per Interceptor");
                        }
                    }
                    this.checkAroundInvokeConditions(annotatedMethod);
                    if (aroundInvokeMethod == null) {
                        aroundInvokeMethod = new ArrayList<Method>();
                    }
                    aroundInvokeMethod.add(annotatedMethod.getJavaMember());
                }
                if (annotatedMethod.getAnnotation(PostConstruct.class) != null) {
                    this.checkSameClassInterceptors(postConstructMethods, annotatedMethod);
                    postConstructMethods.add(annotatedMethod);
                }
                if (annotatedMethod.getAnnotation(PreDestroy.class) != null) {
                    this.checkSameClassInterceptors(preDestroyMethods, annotatedMethod);
                    preDestroyMethods.add(annotatedMethod);
                }
                if (annotatedMethod.getAnnotation(AroundTimeout.class) != null) {
                    this.checkSameClassInterceptors(aroundTimeoutMethods, annotatedMethod);
                    aroundTimeoutMethods.add(annotatedMethod);
                }
                if (this.ejbPlugin == null) continue;
                if (annotatedMethod.getAnnotation(this.prePassivateClass) != null) {
                    this.checkSameClassInterceptors(prePassivateMethods, annotatedMethod);
                    prePassivateMethods.add(annotatedMethod);
                }
                if (annotatedMethod.getAnnotation(AroundTimeout.class) != null) {
                    this.checkSameClassInterceptors(aroundTimeoutMethods, annotatedMethod);
                    postActivateMethods.add(annotatedMethod);
                }
                if (annotatedMethod.getAnnotation(this.postActivateClass) == null) continue;
                this.checkSameClassInterceptors(postActivateMethods, annotatedMethod);
                postActivateMethods.add(annotatedMethod);
            }
        }
        this.interceptionMethods = new HashMap<InterceptionType, Method[]>();
        if (aroundInvokeMethod != null) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.AROUND_INVOKE, aroundInvokeMethod.toArray(new Method[aroundInvokeMethod.size()]));
        }
        if (postConstructMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.POST_CONSTRUCT, this.getMethodArray(postConstructMethods));
        }
        if (preDestroyMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.PRE_DESTROY, this.getMethodArray(preDestroyMethods));
        }
        if (aroundTimeoutMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.AROUND_TIMEOUT, this.getMethodArray(aroundTimeoutMethods));
        }
        if (prePassivateMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.PRE_PASSIVATE, this.getMethodArray(prePassivateMethods));
        }
        if (postActivateMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.POST_ACTIVATE, this.getMethodArray(postActivateMethods));
        }
        if (aroundConstructMethods.size() > 0) {
            interceptorFound = true;
            this.interceptionMethods.put(InterceptionType.AROUND_CONSTRUCT, this.getMethodArray(aroundConstructMethods));
        }
        return interceptorFound;
    }

    private void checkAroundInvokeConditions(AnnotatedMethod method) {
        List parameters = method.getParameters();
        ArrayList clazzParameters = new ArrayList();
        for (AnnotatedParameter parameter : parameters) {
            clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
        }
        Class[] params = clazzParameters.toArray(new Class[clazzParameters.size()]);
        if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
            throw new WebBeansConfigurationException("@AroundInvoke annotated method : " + method.getJavaMember().getName() + " in class : " + this.annotatedType.getJavaClass().getName() + " can not take any formal arguments other than InvocationContext");
        }
        if (!method.getJavaMember().getReturnType().equals(Object.class)) {
            throw new WebBeansConfigurationException("@AroundInvoke annotated method : " + method.getJavaMember().getName() + " in class : " + this.annotatedType.getJavaClass().getName() + " must return Object type");
        }
        if (Modifier.isStatic(method.getJavaMember().getModifiers()) || Modifier.isFinal(method.getJavaMember().getModifiers())) {
            throw new WebBeansConfigurationException("@AroundInvoke annotated method : " + method.getJavaMember().getName() + " in class : " + this.annotatedType.getJavaClass().getName() + " can not be static or final");
        }
    }

    private Method[] getMethodArray(List<AnnotatedMethod> methodList) {
        Method[] methods = new Method[methodList.size()];
        int i = 0;
        for (AnnotatedMethod am : methodList) {
            methods[i++] = am.getJavaMember();
        }
        return methods;
    }

    private void checkSameClassInterceptors(List<AnnotatedMethod> alreadyDefinedMethods, AnnotatedMethod annotatedMethod) {
        Class<?> clazz = null;
        for (AnnotatedMethod alreadyDefined : alreadyDefinedMethods) {
            if (clazz == null) {
                clazz = annotatedMethod.getJavaMember().getDeclaringClass();
            }
            if (alreadyDefined.getJavaMember().getDeclaringClass() != clazz) continue;
            throw new WebBeansConfigurationException("Only one Interceptor of a certain type is allowed per class, but multiple found in class " + annotatedMethod.getJavaMember().getDeclaringClass().getName() + " methods: " + annotatedMethod.getJavaMember().toString() + " and " + alreadyDefined.getJavaMember().toString());
        }
    }

    protected abstract B createBean(Class<T> var1, boolean var2, Map<InterceptionType, Method[]> var3);

    public B getBean() {
        return this.createBean(this.annotatedType.getJavaClass(), this.isInterceptorEnabled(), this.interceptionMethods);
    }
}

