/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.tomcat;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Set;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.meecrowave.configuration.Configuration;

public class TomcatAutoInitializer
implements ServletContainerInitializer {
    @Override
    public void onStartup(Set<Class<?>> c, ServletContext ctx) {
        Configuration builder = (Configuration)Configuration.class.cast(ctx.getAttribute("meecrowave.configuration"));
        if (!builder.isTomcatAutoSetup()) {
            return;
        }
        ServletRegistration.Dynamic def = ctx.addServlet("default", DefaultServlet.class);
        def.setInitParameter("listings", "false");
        def.setInitParameter("debug", "0");
        def.setLoadOnStartup(1);
        def.addMapping("/");
        try {
            String jsp = "org.apache.jasper.servlet.JspServlet";
            TomcatAutoInitializer.class.getClassLoader().loadClass("org.apache.jasper.servlet.JspServlet");
            ServletRegistration.Dynamic jspDef = ctx.addServlet("jsp", "org.apache.jasper.servlet.JspServlet");
            if (jspDef != null) {
                jspDef.setInitParameter("fork", "false");
                jspDef.setInitParameter("xpoweredBy", "false");
                jspDef.setInitParameter("development", Boolean.toString(builder.isTomcatJspDevelopment()));
                jspDef.setLoadOnStartup(3);
                jspDef.addMapping("*.jsp");
                jspDef.addMapping("*.jspx");
            }
        }
        catch (ClassNotFoundException | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }
}

