/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.tomcat;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.tomcat.InstanceManager;
import org.apache.webbeans.servlet.WebBeansConfigurationListener;

public class CDIInstanceManager
implements InstanceManager {
    private final Map<Object, Runnable> destroyables = new ConcurrentHashMap<Object, Runnable>();

    @Override
    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        Object newInstance = clazz.newInstance();
        this.newInstance(newInstance);
        return newInstance;
    }

    @Override
    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(className, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(classLoader.loadClass(fqcn));
    }

    @Override
    public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (WebBeansConfigurationListener.class.isInstance(o) || o.getClass().getName().startsWith("org.apache.catalina.servlets.")) {
            return;
        }
        BeanManager bm = CDI.current().getBeanManager();
        AnnotatedType<?> annotatedType = bm.createAnnotatedType(o.getClass());
        InjectionTarget<?> injectionTarget = bm.createInjectionTarget(annotatedType);
        CreationalContext creationalContext = bm.createCreationalContext(null);
        injectionTarget.inject(o, creationalContext);
        try {
            injectionTarget.postConstruct(o);
        }
        catch (RuntimeException e) {
            creationalContext.release();
            throw e;
        }
        this.destroyables.put(o, () -> {
            try {
                injectionTarget.preDestroy(o);
            }
            finally {
                creationalContext.release();
            }
        });
    }

    @Override
    public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        Optional.ofNullable(this.destroyables.remove(o)).ifPresent(Runnable::run);
    }
}

