/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.openwebbeans;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.security.auth.Subject;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.security.SimpleSecurityService;

public class MeecrowaveSecurityService
extends SimpleSecurityService {
    private final boolean useWrapper;
    private final Principal proxy;

    public MeecrowaveSecurityService(WebBeansContext context) {
        this.useWrapper = "true".equalsIgnoreCase(context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.component.PrincipalBean.proxy", "true"));
        ClassLoader loader = SimpleSecurityService.class.getClassLoader();
        Class[] apiToProxy = (Class[])Stream.concat(Stream.of(Principal.class), Stream.of(context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.component.PrincipalBean.proxyApis", "org.eclipse.microprofile.jwt.JsonWebToken").split(",")).map(String::trim).filter(it -> !it.isEmpty()).map(it -> {
            try {
                return loader.loadClass(it.trim());
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                return null;
            }
        })).filter(Objects::nonNull).toArray(Class[]::new);
        this.proxy = apiToProxy.length == 1 ? new MeecrowavePrincipal() : (Principal)Principal.class.cast(Proxy.newProxyInstance(loader, apiToProxy, (proxy, method, args) -> {
            try {
                return method.invoke((Object)this.getCurrentPrincipal(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getTargetException();
            }
        }));
    }

    @Override
    public Principal getCurrentPrincipal() {
        return this.useWrapper ? this.proxy : MeecrowaveSecurityService.getUserPrincipal();
    }

    private static Principal getUserPrincipal() {
        BeanManager beanManager = CDI.current().getBeanManager();
        HttpServletRequest request = (HttpServletRequest)HttpServletRequest.class.cast(beanManager.getReference(beanManager.resolve(beanManager.getBeans((Type)((Object)HttpServletRequest.class), new Annotation[0])), (Type)((Object)HttpServletRequest.class), beanManager.createCreationalContext(null)));
        Object supplier = request.getAttribute(Principal.class.getName() + ".supplier");
        if (supplier != null) {
            return (Principal)((Supplier)supplier).get();
        }
        return request.getUserPrincipal();
    }

    private static class MeecrowavePrincipal
    implements Principal {
        private MeecrowavePrincipal() {
        }

        @Override
        public String getName() {
            return this.unwrap().getName();
        }

        @Override
        public boolean implies(Subject subject) {
            return this.unwrap().implies(subject);
        }

        private Principal unwrap() {
            return MeecrowaveSecurityService.getUserPrincipal();
        }
    }
}

