/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.openwebbeans;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.ws.rs.Path;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.meecrowave.cxf.Cxfs;
import org.apache.meecrowave.cxf.JAXRSFieldInjectionInterceptor;
import org.apache.meecrowave.cxf.MeecrowaveBus;
import org.apache.webbeans.container.AnnotatedTypeWrapper;

public class MeecrowaveExtension
implements Extension {
    void addBeansFromJava(@Observes BeforeBeanDiscovery bbd, BeanManager bm) {
        if (Cxfs.IS_PRESENT) {
            bbd.addInterceptorBinding(JAXRSFieldInjectionInterceptor.Binding.class, new Annotation[0]);
            Stream.of(MeecrowaveBus.class, JAXRSFieldInjectionInterceptor.class).forEach(type -> bbd.addAnnotatedType(bm.createAnnotatedType(type)));
        }
    }

    void onPat(@Observes ProcessAnnotatedType<?> pat, BeanManager bm) {
        AnnotatedType<?> at = pat.getAnnotatedType();
        if (this.isJaxRsEndpoint(bm, at)) {
            pat.setAnnotatedType(new JAXRSFIeldInjectionAT((Extension)this, at));
        } else if (this.isVetoedMeecrowaveCore(at.getJavaClass().getName())) {
            pat.veto();
        }
    }

    private boolean isJaxRsEndpoint(BeanManager bm, AnnotatedType<?> at) {
        return Cxfs.IS_PRESENT && at.isAnnotationPresent(Path.class) && !at.isAnnotationPresent(JAXRSFieldInjectionInterceptor.Binding.class) && at.getAnnotations().stream().anyMatch(a -> bm.isNormalScope(a.annotationType()));
    }

    private boolean isVetoedMeecrowaveCore(String name) {
        return !"org.apache.meecrowave.cxf.MeecrowaveBus".equals(name) && !"org.apache.meecrowave.cxf.JAXRSFieldInjectionInterceptor".equals(name) && (name.startsWith("org.apache.meecrowave.api.") || name.startsWith("org.apache.meecrowave.cdi.") || name.startsWith("org.apache.meecrowave.configuration.") || name.startsWith("org.apache.meecrowave.cxf.") || name.startsWith("org.apache.meecrowave.io.") || name.startsWith("org.apache.meecrowave.lang.") || name.startsWith("org.apache.meecrowave.logging.") || name.startsWith("org.apache.meecrowave.openwebbeans.") || name.startsWith("org.apache.meecrowave.runner.") || name.startsWith("org.apache.meecrowave.service.") || name.startsWith("org.apache.meecrowave.tomcat.") || name.startsWith("org.apache.meecrowave.watching.") || name.equals("org.apache.meecrowave.Meecrowave"));
    }

    private static class JAXRSFIeldInjectionAT<T>
    extends AnnotatedTypeWrapper<T> {
        private final Set<Annotation> annotations;

        private JAXRSFIeldInjectionAT(Extension extension, AnnotatedType<T> original) {
            super(extension, original, AnnotatedTypeWrapper.class.isInstance(original) ? ((AnnotatedTypeWrapper)AnnotatedTypeWrapper.class.cast(original)).getId() : JAXRSFIeldInjectionAT.getDefaultId(extension, original));
            this.annotations = new HashSet<Annotation>(original.getAnnotations().size() + 1);
            this.annotations.addAll(original.getAnnotations());
            this.annotations.add(JAXRSFieldInjectionInterceptor.Binding.INSTANCE);
        }

        @Override
        public Set<Annotation> getAnnotations() {
            return this.annotations;
        }

        @Override
        public <T1 extends Annotation> T1 getAnnotation(Class<T1> t1Class) {
            return (T1)(t1Class == JAXRSFieldInjectionInterceptor.Binding.class ? (Annotation)t1Class.cast(JAXRSFieldInjectionInterceptor.Binding.INSTANCE) : super.getAnnotation(t1Class));
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> aClass) {
            return JAXRSFieldInjectionInterceptor.Binding.class == aClass || super.isAnnotationPresent(aClass);
        }

        private static <T> String getDefaultId(Extension extension, AnnotatedType<T> original) {
            return extension.getClass().getName() + original + "OWB_DEFAULT_KEY";
        }
    }
}

