/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.openwebbeans;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;

public class KnownJarsFilter
implements JarScanFilter {
    private final Collection<String> forceIncludes = new HashSet<String>(){
        {
            this.add("cxf-integration-cdi");
            this.add("geronimo-jcache-simple");
        }
    };
    private final Collection<String> excludes = new HashSet<String>(){
        {
            this.add("activation-");
            this.add("activeio-");
            this.add("activemq-");
            this.add("aether-");
            this.add("akka-actor-");
            this.add("akka-cluster-");
            this.add("akka-remote-");
            this.add("animal-sniffer-annotations-");
            this.add("ant-");
            this.add("antlr-");
            this.add("aopalliance-");
            this.add("ApacheJMeter");
            this.add("apiguardian-");
            this.add("args4j-");
            this.add("arquillian-common");
            this.add("arquillian-config-");
            this.add("arquillian-container-");
            this.add("arquillian-core-api-");
            this.add("arquillian-core-impl-base");
            this.add("arquillian-core.jar");
            this.add("arquillian-core-spi-");
            this.add("arquillian-junit-");
            this.add("arquillian-junit.jar");
            this.add("arquillian-test-api");
            this.add("arquillian-test-impl-base");
            this.add("arquillian-testng.jar");
            this.add("arquillian-test-spi");
            this.add("arquillian-tomee-");
            this.add("arquillian-transaction.jar");
            this.add("asciidoctorj-");
            this.add("asm-");
            this.add("async-http-client-");
            this.add("avalon-framework-");
            this.add("avro-");
            this.add("axis-");
            this.add("axis2-");
            this.add("batchee-jbatch");
            this.add("batik-");
            this.add("bcprov-");
            this.add("beam-");
            this.add("bootstrap.jar");
            this.add("bsf-");
            this.add("bval-core");
            this.add("bval-jsr");
            this.add("c3p0-");
            this.add("cassandra-driver-core");
            this.add("catalina-");
            this.add("catalina.jar");
            this.add("cglib-");
            this.add("charsets.jar");
            this.add("checker-qual");
            this.add("common-java5");
            this.add("common-junit");
            this.add("commons-beanutils");
            this.add("commons-cli-");
            this.add("commons-codec-");
            this.add("commons-collections-");
            this.add("commons-compress-");
            this.add("commons-configuration-");
            this.add("commons-dbcp");
            this.add("commons-dbcp-all-1.3-");
            this.add("commons-digester-");
            this.add("commons-discovery-");
            this.add("commons-fileupload-");
            this.add("commons-httpclient-");
            this.add("commons-io-");
            this.add("commons-jcs-core-");
            this.add("commons-lang-");
            this.add("commons-lang3-");
            this.add("commons-logging-");
            this.add("commons-logging-api-");
            this.add("commons-net-");
            this.add("commons-pool-");
            this.add("commons-pool2-");
            this.add("commons-text-");
            this.add("cryptacular-");
            this.add("cssparser-");
            this.add("cxf-");
            this.add("deploy.jar");
            this.add("derby-");
            this.add("derbyclient-");
            this.add("derbynet-");
            this.add("dom4j");
            this.add("ecj-");
            this.add("eclipselink-");
            this.add("ehcache-");
            this.add("el-api");
            this.add("error_prone_annotations");
            this.add("failureaccess");
            this.add("FastInfoset");
            this.add("freemarker-");
            this.add("fusemq-leveldb-");
            this.add("geronimo-connector-");
            this.add("geronimo-j2ee");
            this.add("geronimo-jpa");
            this.add("geronimo-javamail");
            this.add("geronimo-transaction");
            this.add("google-");
            this.add("gpars-");
            this.add("gragent.jar");
            this.add("groovy-");
            this.add("gson-");
            this.add("guava-");
            this.add("guice-");
            this.add("h2-");
            this.add("hamcrest-");
            this.add("hawtbuf-");
            this.add("hawtdispatch-");
            this.add("hawtio-");
            this.add("hawtjni-runtime");
            this.add("hibernate-");
            this.add("howl-");
            this.add("hsqldb-");
            this.add("htmlunit-");
            this.add("httpclient-");
            this.add("httpcore-");
            this.add("icu4j-");
            this.add("idb-");
            this.add("idea_rt.jar");
            this.add("istack-commons-runtime-");
            this.add("ivy-");
            this.add("j2objc-");
            this.add("jackson-annotations-");
            this.add("jackson-core-");
            this.add("jackson-databind-");
            this.add("jackson-mapper-asl-");
            this.add("jackson-module-jaxb-annotations-");
            this.add("janino-");
            this.add("jansi-");
            this.add("jasper-el.jar");
            this.add("jasper.jar");
            this.add("jasypt-");
            this.add("java-atk-wrapper");
            this.add("javaee-");
            this.add("javaee-api");
            this.add("javassist-");
            this.add("java-support-");
            this.add("javaws.jar");
            this.add("javax.");
            this.add("jaxb-");
            this.add("jaxp-");
            this.add("jaxws-api");
            this.add("jbake-");
            this.add("jboss-");
            this.add("jbossall-");
            this.add("jbosscx-");
            this.add("jbossjts-");
            this.add("jbosssx-");
            this.add("jce.jar");
            this.add("jcommander-");
            this.add("jersey-");
            this.add("jettison-");
            this.add("jetty-");
            this.add("jfr.jar");
            this.add("jfxrt.jar");
            this.add("jib-");
            this.add("jline");
            this.add("jmdns-");
            this.add("jna-");
            this.add("jnr-");
            this.add("joda-time-");
            this.add("johnzon-");
            this.add("jolokia-core-");
            this.add("jolokia-jvm-");
            this.add("jolokia-serv");
            this.add("jruby-");
            this.add("jsonb-api");
            this.add("json-simple-");
            this.add("jsoup-");
            this.add("jsp-api");
            this.add("jsr166");
            this.add("jsr299-");
            this.add("jsr305");
            this.add("jsr311-");
            this.add("jsse.jar");
            this.add("juli-");
            this.add("jul-to-slf4j-");
            this.add("junit-");
            this.add("junit5-");
            this.add("jython-");
            this.add("kahadb-");
            this.add("kotlin-runtime");
            this.add("leveldb");
            this.add("listenablefuture");
            this.add("log4j-");
            this.add("logkit-");
            this.add("lombok-");
            this.add("lucene-analyzers-");
            this.add("lucene-core-");
            this.add("management-agent.jar");
            this.add("maven-");
            this.add("mbean-annotation-api-");
            this.add("meecrowave-gradle-");
            this.add("meecrowave-maven-");
            this.add("meecrowave-specs-api-");
            this.add("microprofile-config-api-");
            this.add("microprofile-fault-tolerance-api-");
            this.add("microprofile-health-api-");
            this.add("microprofile-jwt-auth-api-");
            this.add("microprofile-metrics-api-");
            this.add("microprofile-openapi-api-");
            this.add("microprofile-opentracing-api-");
            this.add("mimepull-");
            this.add("mina-");
            this.add("mqtt-client-");
            this.add("multiverse-core-");
            this.add("myfaces-api");
            this.add("myfaces-impl");
            this.add("mysql-connector-java-");
            this.add("neethi-");
            this.add("nekohtml-");
            this.add("netty-");
            this.add("openjpa-");
            this.add("openmdx-");
            this.add("opensaml-");
            this.add("opentest4j-");
            this.add("openwebbeans-");
            this.add("openws-");
            this.add("ops4j-");
            this.add("org.apache.aries.blueprint.noosgi");
            this.add("org.apache.aries.blueprint.web");
            this.add("org.eclipse.");
            this.add("org.jacoco.agent");
            this.add("org.junit.");
            this.add("org.osgi.annotation.versioning");
            this.add("org.osgi.core-");
            this.add("org.osgi.enterprise");
            this.add("orient-commons-");
            this.add("orientdb-core-");
            this.add("orientdb-nativeos-");
            this.add("oro-");
            this.add("paranamer-");
            this.add("pax-url");
            this.add("PDFBox");
            this.add("plexus-");
            this.add("plugin.jar");
            this.add("poi-");
            this.add("qdox-");
            this.add("quartz-2");
            this.add("quartz-openejb-");
            this.add("resources.jar");
            this.add("rhino-");
            this.add("rmock-");
            this.add("rt.jar");
            this.add("saaj-");
            this.add("sac-");
            this.add("scala-library-");
            this.add("scalatest");
            this.add("scannotation-");
            this.add("serializer-");
            this.add("serp-");
            this.add("servlet-api-");
            this.add("shrinkwrap-");
            this.add("sisu-guice");
            this.add("sisu-inject");
            this.add("slf4j-");
            this.add("smack-");
            this.add("smackx-");
            this.add("snappy-");
            this.add("spring-");
            this.add("sshd-");
            this.add("stax2-api-");
            this.add("stax-api-");
            this.add("stax-ex-");
            this.add("sunec.jar");
            this.add("surefire-");
            this.add("swizzle-");
            this.add("sxc-");
            this.add("testng-");
            this.add("tomcat-annotations");
            this.add("tomcat-api");
            this.add("tomcat-catalina");
            this.add("tomcat-coyote");
            this.add("tomcat-dbcp");
            this.add("tomcat-el");
            this.add("tomcat-i18n");
            this.add("tomcat-jasper");
            this.add("tomcat-jaspic");
            this.add("tomcat-jdbc");
            this.add("tomcat-jni");
            this.add("tomcat-jsp");
            this.add("tomcat-juli");
            this.add("tomcat-servlet");
            this.add("tomcat-spdy");
            this.add("tomcat-tribes");
            this.add("tomcat-util");
            this.add("tomcat-websocket-api");
            this.add("tomee-");
            this.add("tools.jar");
            this.add("twitter4j-");
            this.add("validation-api-");
            this.add("velocity-");
            this.add("wagon-");
            this.add("webbeans-ee");
            this.add("webbeans-ejb");
            this.add("webbeans-impl");
            this.add("webbeans-spi");
            this.add("websocket-api");
            this.add("woodstox-core-");
            this.add("ws-commons-util-");
            this.add("wsdl4j-");
            this.add("wss4j-");
            this.add("wstx-asl-");
            this.add("xalan-");
            this.add("xbean-");
            this.add("xercesImpl-");
            this.add("xml-apis-");
            this.add("xmlbeans-");
            this.add("xmlgraphics-");
            this.add("xmlpull-");
            this.add("xml-resolver-");
            this.add("xmlrpc-");
            this.add("xmlschema-");
            this.add("XmlSchema-");
            this.add("xmlsec-");
            this.add("xmltooling-");
            this.add("xmlunit-");
            this.add("xstream-");
            this.add("xz-");
            this.add("zipfs.jar");
            this.add("ziplock-");
        }
    };

    public KnownJarsFilter() {
    }

    KnownJarsFilter(Configuration config) {
        Optional.ofNullable(config.getScanningIncludes()).ifPresent(i -> {
            this.forceIncludes.clear();
            this.forceIncludes.addAll(Stream.of(i.split(",")).map(String::trim).filter(j -> !j.isEmpty()).collect(Collectors.toSet()));
        });
        Optional.ofNullable(config.getScanningExcludes()).ifPresent(i -> this.excludes.addAll(Stream.of(i.split(",")).map(String::trim).filter(j -> !j.isEmpty()).collect(Collectors.toSet())));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean check(JarScanType jarScanType, String jarName) {
        if (this.forceIncludes.stream().anyMatch(jarName::startsWith)) return true;
        if (!this.excludes.stream().noneMatch(jarName::startsWith)) return false;
        if (this.isGeronimoSpecJar(jarName)) return false;
        return true;
    }

    private boolean isGeronimoSpecJar(String jarName) {
        return jarName.startsWith("geronimo") && jarName.contains("_spec");
    }
}

