/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Objects;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientLifeCycleListener;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.johnzon.jsonb.JohnzonJsonb;
import org.apache.johnzon.jsonb.cdi.JohnzonCdiExtension;
import org.apache.meecrowave.cxf.ConfigurableBus;
import org.apache.meecrowave.logging.tomcat.LogFacade;

public class MeecrowaveClientLifecycleListener
implements ClientLifeCycleListener {
    private final Method getReadersWriters;
    private final Field delegate;
    private final Field instance;

    public MeecrowaveClientLifecycleListener() {
        try {
            this.getReadersWriters = ProviderFactory.class.getDeclaredMethod("getReadersWriters", new Class[0]);
            this.getReadersWriters.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Incompatible cxf version detected", e);
        }
        try {
            this.delegate = JsonbJaxrsProvider.class.getDeclaredField("delegate");
            this.delegate.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("Incompatible johnzon version detected", e);
        }
        try {
            this.instance = JsonbJaxrsProvider.class.getClassLoader().loadClass("org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider$ProvidedInstance").getDeclaredField("instance");
            this.instance.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Incompatible johnzon version detected", e);
        }
    }

    @Override
    public void clientCreated(Client client) {
    }

    @Override
    public void clientDestroyed(Client client) {
        try {
            ClientProviderFactory cpf = (ClientProviderFactory)ClientProviderFactory.class.cast(client.getEndpoint().get(ClientProviderFactory.class.getName()));
            Collection invoke = (Collection)Collection.class.cast(this.getReadersWriters.invoke((Object)cpf, new Object[0]));
            invoke.stream().map(p -> ProviderInfo.class.isInstance(p) ? ((ProviderInfo)ProviderInfo.class.cast(p)).getProvider() : p).filter(p -> !ConfigurableBus.ConfiguredJsonbJaxrsProvider.class.isInstance(p) && JsonbJaxrsProvider.class.isInstance(p)).map(JsonbJaxrsProvider.class::cast).map(p -> {
                try {
                    return this.instance.get(this.delegate.get(p));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }).filter(Objects::nonNull).filter(JohnzonJsonb.class::isInstance).map(JohnzonJsonb.class::cast).distinct().forEach(jsonb -> ((JohnzonCdiExtension)CDI.current().select(JohnzonCdiExtension.class, new Annotation[0]).get()).untrack((JohnzonJsonb)jsonb));
        }
        catch (RuntimeException re) {
            new LogFacade(MeecrowaveClientLifecycleListener.class.getName()).debug(re.getMessage(), re);
        }
        catch (Exception re) {
            new LogFacade(MeecrowaveClientLifecycleListener.class.getName()).error(re.getMessage(), re);
        }
    }
}

