/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassUnwrapper;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.cxf.ConfigurableBus;

@Named(value="cxf")
@Typed(value={MeecrowaveBus.class, Bus.class})
@ApplicationScoped
public class MeecrowaveBus
implements Bus,
ClassUnwrapper {
    private final ConfigurableBus delegate;

    protected MeecrowaveBus() {
        this.delegate = null;
    }

    @Inject
    public MeecrowaveBus(ServletContext context) {
        ClassLoader appLoader = context.getClassLoader();
        Meecrowave meecrowave = (Meecrowave)Meecrowave.class.cast(context.getAttribute("meecrowave.instance"));
        Configuration builder = (Configuration)Configuration.class.cast(context.getAttribute("meecrowave.configuration"));
        if (meecrowave.getClientBus() == null) {
            this.delegate = new ConfigurableBus();
            if (builder != null && builder.isJaxrsProviderSetup()) {
                this.delegate.initProviders(builder, appLoader);
            }
        } else {
            this.delegate = meecrowave.getClientBus();
            if (builder != null && !builder.isInitializeClientBus() && builder.isJaxrsProviderSetup()) {
                this.delegate.initProviders(builder, appLoader);
            }
        }
        this.setProperty(ClassUnwrapper.class.getName(), this);
        this.setExtension(appLoader, ClassLoader.class);
    }

    @Override
    public Class<?> getRealClass(Object o) {
        return this.getRealClassFromClass(o.getClass());
    }

    @Override
    public Class<?> getRealClassFromClass(Class<?> aClass) {
        if (aClass.getName().contains("$$")) {
            Class<?>[] interfaces;
            Class<?> realClass = aClass.getSuperclass();
            if ((realClass == Object.class || realClass.isInterface()) && (interfaces = aClass.getInterfaces()).length > 0) {
                Class<?> rootInterface = interfaces[0];
                for (Class<?> anInterface : interfaces) {
                    if (!rootInterface.isAssignableFrom(anInterface)) continue;
                    rootInterface = anInterface;
                }
                return rootInterface;
            }
            return realClass;
        }
        return aClass;
    }

    @Override
    public <T> T getExtension(Class<T> extensionType) {
        return this.delegate.getExtension(extensionType);
    }

    @Override
    public <T> void setExtension(T extension, Class<T> extensionType) {
        this.delegate.setExtension(extension, extensionType);
    }

    @Override
    public boolean hasExtensionByName(String name) {
        return this.delegate.hasExtensionByName(name);
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public void setId(String i) {
        this.delegate.setId(i);
    }

    @Override
    public void shutdown(boolean wait) {
        this.delegate.shutdown(wait);
    }

    @Override
    public void setProperty(String s, Object o) {
        this.delegate.setProperty(s, o);
    }

    @Override
    public Object getProperty(String s) {
        return this.delegate.getProperty(s);
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        this.delegate.setProperties(properties);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.delegate.getProperties();
    }

    @Override
    public Collection<Feature> getFeatures() {
        return this.delegate.getFeatures();
    }

    @Override
    public void setFeatures(Collection<? extends Feature> features) {
        this.delegate.setFeatures(features);
    }

    @Override
    public Bus.BusState getState() {
        return this.delegate.getState();
    }

    @Override
    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.delegate.getInInterceptors();
    }

    @Override
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.delegate.getOutInterceptors();
    }

    @Override
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        return this.delegate.getInFaultInterceptors();
    }

    @Override
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        return this.delegate.getOutFaultInterceptors();
    }
}

