/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cxf;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonMergePatch;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonPatch;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonPointer;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cxf.bus.extension.ExtensionManagerBus;
import org.apache.cxf.bus.managers.ClientLifeCycleManagerImpl;
import org.apache.cxf.endpoint.ClientLifeCycleManager;
import org.apache.johnzon.jaxrs.jsonb.jaxrs.JsonbJaxrsProvider;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.cxf.MeecrowaveClientLifecycleListener;

public class ConfigurableBus
extends ExtensionManagerBus {
    public void initProviders(final Configuration builder, ClassLoader loader) {
        List providers = Optional.ofNullable(builder.getJaxrsDefaultProviders()).map(s -> Stream.of(s.split(" *, *")).map(String::trim).filter(p -> !p.isEmpty()).map(name -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)name).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(name + " can't be created");
            }
        }).collect(Collectors.toList())).orElseGet(() -> {
            JsonProvider provider = JsonProvider.provider();
            JsonReaderFactory readerFactory = provider.createReaderFactory(new HashMap<String, Object>(){
                {
                    this.put("org.apache.johnzon.supports-comments", builder.isJsonpSupportsComment());
                    Optional.of(builder.getJsonpMaxStringLen()).filter(v -> v > 0).ifPresent(s -> this.put("org.apache.johnzon.max-string-length", s));
                    Optional.of(builder.getJsonpMaxReadBufferLen()).filter(v -> v > 0).ifPresent(s -> this.put("org.apache.johnzon.default-char-buffer", s));
                    Optional.ofNullable(builder.getJsonpBufferStrategy()).ifPresent(s -> this.put("org.apache.johnzon.buffer-strategy", s));
                }
            });
            JsonWriterFactory writerFactory = provider.createWriterFactory(new HashMap<String, Object>(){
                {
                    this.put("jakarta.json.stream.JsonGenerator.prettyPrinting", builder.isJsonpPrettify());
                    Optional.of(builder.getJsonpMaxWriteBufferLen()).filter(v -> v > 0).ifPresent(v -> this.put("org.apache.johnzon.default-char-buffer-generator", v));
                    Optional.ofNullable(builder.getJsonpBufferStrategy()).ifPresent(s -> this.put("org.apache.johnzon.buffer-strategy", s));
                }
            });
            return Stream.of(new ConfiguredJsonbJaxrsProvider(builder.getJsonbEncoding(), builder.isJsonbNulls(), builder.isJsonbIJson(), builder.isJsonbPrettify(), builder.getJsonbBinaryStrategy(), builder.getJsonbNamingStrategy(), builder.getJsonbOrderStrategy(), new DelegateJsonProvider(provider, readerFactory, writerFactory))).collect(Collectors.toList());
        });
        if (builder.isJaxrsAutoActivateBeanValidation()) {
            try {
                loader.loadClass("jakarta.validation.Validation");
                Object instance = loader.loadClass("org.apache.cxf.jaxrs.validation.ValidationExceptionMapper").getConstructor(new Class[0]).newInstance(new Object[0]);
                instance.getClass().getGenericInterfaces();
                providers.add(instance);
            }
            catch (Exception | NoClassDefFoundError throwable) {
                // empty catch block
            }
        }
        if (this.getProperty("org.apache.cxf.jaxrs.bus.providers") == null) {
            this.setProperty("skip.default.json.provider.registration", "true");
            this.setProperty("org.apache.cxf.jaxrs.bus.providers", providers);
        }
    }

    public void addClientLifecycleListener() {
        ClientLifeCycleManager manager = this.getExtension(ClientLifeCycleManager.class);
        if (manager == null) {
            manager = new ClientLifeCycleManagerImpl();
            this.setExtension(manager, ClientLifeCycleManager.class);
        }
        manager.registerListener(new MeecrowaveClientLifecycleListener());
    }

    private static class DelegateJsonProvider
    extends JsonProvider {
        private final JsonReaderFactory readerFactory;
        private final JsonWriterFactory writerFactory;
        private final JsonProvider provider;

        private DelegateJsonProvider(JsonProvider provider, JsonReaderFactory readerFactory, JsonWriterFactory writerFactory) {
            this.provider = provider;
            this.readerFactory = readerFactory;
            this.writerFactory = writerFactory;
        }

        @Override
        public JsonWriterFactory createWriterFactory(Map<String, ?> config) {
            return this.writerFactory;
        }

        @Override
        public JsonReaderFactory createReaderFactory(Map<String, ?> config) {
            return this.readerFactory;
        }

        @Override
        public JsonParser createParser(Reader reader) {
            return this.provider.createParser(reader);
        }

        @Override
        public JsonParser createParser(InputStream in) {
            return this.provider.createParser(in);
        }

        @Override
        public JsonParserFactory createParserFactory(Map<String, ?> config) {
            return this.provider.createParserFactory(config);
        }

        @Override
        public JsonGenerator createGenerator(Writer writer) {
            return this.provider.createGenerator(writer);
        }

        @Override
        public JsonGenerator createGenerator(OutputStream out) {
            return this.provider.createGenerator(out);
        }

        @Override
        public JsonGeneratorFactory createGeneratorFactory(Map<String, ?> config) {
            return this.provider.createGeneratorFactory(config);
        }

        @Override
        public JsonReader createReader(Reader reader) {
            return this.provider.createReader(reader);
        }

        @Override
        public JsonReader createReader(InputStream in) {
            return this.provider.createReader(in);
        }

        @Override
        public JsonWriter createWriter(Writer writer) {
            return this.provider.createWriter(writer);
        }

        @Override
        public JsonWriter createWriter(OutputStream out) {
            return this.provider.createWriter(out);
        }

        @Override
        public JsonObjectBuilder createObjectBuilder() {
            return this.provider.createObjectBuilder();
        }

        @Override
        public JsonObjectBuilder createObjectBuilder(JsonObject jsonObject) {
            return this.provider.createObjectBuilder(jsonObject);
        }

        @Override
        public JsonObjectBuilder createObjectBuilder(Map<String, Object> map) {
            return this.provider.createObjectBuilder(map);
        }

        @Override
        public JsonArrayBuilder createArrayBuilder() {
            return this.provider.createArrayBuilder();
        }

        @Override
        public JsonArrayBuilder createArrayBuilder(JsonArray initialData) {
            return this.provider.createArrayBuilder(initialData);
        }

        @Override
        public JsonArrayBuilder createArrayBuilder(Collection<?> initialData) {
            return this.provider.createArrayBuilder(initialData);
        }

        @Override
        public JsonPointer createPointer(String path) {
            return this.provider.createPointer(path);
        }

        @Override
        public JsonBuilderFactory createBuilderFactory(Map<String, ?> config) {
            return this.provider.createBuilderFactory(config);
        }

        @Override
        public JsonString createValue(String value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonNumber createValue(int value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonNumber createValue(long value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonNumber createValue(double value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonNumber createValue(BigDecimal value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonNumber createValue(BigInteger value) {
            return this.provider.createValue(value);
        }

        @Override
        public JsonPatch createPatch(JsonArray array) {
            return this.provider.createPatch(array);
        }

        @Override
        public JsonPatch createDiff(JsonStructure source, JsonStructure target) {
            return this.provider.createDiff(source, target);
        }

        @Override
        public JsonPatchBuilder createPatchBuilder() {
            return this.provider.createPatchBuilder();
        }

        @Override
        public JsonPatchBuilder createPatchBuilder(JsonArray initialData) {
            return this.provider.createPatchBuilder(initialData);
        }

        @Override
        public JsonMergePatch createMergePatch(JsonValue patch) {
            return this.provider.createMergePatch(patch);
        }

        @Override
        public JsonMergePatch createMergeDiff(JsonValue source, JsonValue target) {
            return this.provider.createMergeDiff(source, target);
        }
    }

    @Provider
    @Produces(value={"application/json", "application/*+json"})
    @Consumes(value={"application/json", "application/*+json"})
    public static class ConfiguredJsonbJaxrsProvider<T>
    extends JsonbJaxrsProvider<T> {
        private final Jsonb jsonb;

        private ConfiguredJsonbJaxrsProvider(String encoding, boolean nulls, boolean iJson, boolean pretty, String binaryStrategy, String namingStrategy, String orderStrategy, JsonProvider provider) {
            super(Collections.singletonList("[B"));
            Optional.ofNullable(encoding).ifPresent(this::setEncoding);
            Optional.ofNullable(namingStrategy).ifPresent(this::setPropertyNamingStrategy);
            Optional.ofNullable(orderStrategy).ifPresent(this::setPropertyOrderStrategy);
            Optional.ofNullable(binaryStrategy).ifPresent(this::setBinaryDataStrategy);
            this.setNullValues(nulls);
            this.setIJson(iJson);
            this.setPretty(pretty);
            this.jsonb = JsonbBuilder.newBuilder().withProvider(provider).withConfig(this.config).build();
        }

        @Override
        protected Jsonb createJsonb() {
            return this.jsonb;
        }

        @Override
        public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return super.isReadable(type, genericType, annotations, mediaType) || JsonValue.class.isAssignableFrom(type);
        }

        @Override
        public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
            return super.isWriteable(type, genericType, annotations, mediaType) || JsonValue.class.isAssignableFrom(type);
        }
    }
}

