/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.cdi;

import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.se.SeContainerInitializer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.logging.jul.Log4j2Logger;
import org.apache.meecrowave.logging.openwebbeans.Log4j2LoggerFactory;
import org.apache.meecrowave.logging.tomcat.Log4j2Log;
import org.apache.meecrowave.openwebbeans.KnownClassesFilter;
import org.apache.meecrowave.openwebbeans.OWBTomcatWebScannerService;
import org.apache.openwebbeans.se.CDISeScannerService;
import org.apache.openwebbeans.se.OWBContainer;
import org.apache.openwebbeans.se.OWBInitializer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.web.context.WebContextsService;
import org.apache.xbean.finder.filter.Filter;

public class MeecrowaveSeContainerInitializer
extends OWBInitializer {
    private Configuration builder = new Meecrowave.Builder();

    public SeContainerInitializer addProperty(String s, Object o) {
        if (Configuration.class.isInstance(o)) {
            this.builder = (Configuration)Configuration.class.cast(o);
            return this;
        }
        String setter = "set" + Character.toUpperCase(s.charAt(0)) + s.substring(1);
        Class<?> builderClass = this.builder.getClass();
        Optional<Method> setterOpt = Stream.of(Configuration.class.getMethods()).filter(m -> m.getName().equals(setter) && m.getParameterCount() == 1).findFirst();
        if (!setterOpt.isPresent()) {
            super.addProperty(s, o);
            return this;
        }
        try {
            builderClass.getMethod(setter, o.getClass()).invoke((Object)this.builder, o);
        }
        catch (NoSuchMethodException nsme) {
            if (Integer.class.isInstance(o)) {
                try {
                    builderClass.getMethod(setter, Integer.TYPE).invoke((Object)this.builder, o);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalArgumentException(nsme);
                }
            }
            if (Long.class.isInstance(o)) {
                try {
                    builderClass.getMethod(setter, Long.TYPE).invoke((Object)this.builder, o);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalArgumentException(nsme);
                }
            }
            if (Boolean.class.isInstance(o)) {
                try {
                    builderClass.getMethod(setter, Boolean.TYPE).invoke((Object)this.builder, o);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalArgumentException(nsme);
                }
            }
            throw new IllegalArgumentException(nsme);
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        return this;
    }

    protected void addCustomServices(Map<String, Object> services) {
        final Set forced = this.scannerService.configuredClasses().stream().map(Class::getName).collect(Collectors.toSet());
        services.put(Filter.class.getName(), new KnownClassesFilter(){

            @Override
            public boolean accept(String name) {
                return forced.contains(name) || super.accept(name);
            }
        });
    }

    protected SeContainer newContainer(WebBeansContext context) {
        final Meecrowave meecrowave = new Meecrowave(this.builder);
        if (!this.services.containsKey(ContextsService.class.getName())) {
            context.registerService(ContextsService.class, new WebContextsService(context));
        }
        return new OWBContainer(context, meecrowave){
            {
                super(x0, x1);
                meecrowave.bake();
            }

            protected void doClose() {
                meecrowave.close();
            }
        };
    }

    protected ScannerService getScannerService() {
        return new OWBTomcatWebScannerService((BdaScannerService)this.scannerService, () -> ((CDISeScannerService)this.scannerService).getFinder());
    }

    static {
        System.setProperty("java.util.logging.manager", System.getProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager"));
        System.setProperty("openwebbeans.logging.factory", System.getProperty("openwebbeans.logging.factory", Log4j2LoggerFactory.class.getName()));
        System.setProperty("org.apache.cxf.Logger", System.getProperty("org.apache.cxf.Logger", Log4j2Logger.class.getName()));
        System.setProperty("org.apache.tomcat.Logger", System.getProperty("org.apache.tomcat.Logger", Log4j2Log.class.getName()));
    }
}

