/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.mapper;

import jakarta.json.JsonObject;
import java.lang.reflect.Constructor;
import java.util.stream.Stream;
import org.apache.johnzon.mapper.ExceptionMessages;
import org.apache.johnzon.mapper.MapperException;

public class MissingFactoryException
extends MapperException {
    public MissingFactoryException(Class<?> clazz, JsonObject object, String json) {
        super(MissingFactoryException.message(clazz, object, json));
    }

    private static String message(Class<?> clazz, JsonObject object, String json) {
        if (clazz.isArray()) {
            return String.format("%s array not a suitable datatype for %s: %s", clazz.getSimpleName(), ExceptionMessages.description(object), json);
        }
        if (clazz.isInterface()) {
            return String.format("%s is an interface and requires an adapter or factory.  Cannot deserialize %s: %s%n%s not instantiable", clazz.getSimpleName(), ExceptionMessages.description(object), json, clazz);
        }
        String message = String.format("%s has no suitable constructor or factory.  Cannot deserialize %s: %s", clazz.getSimpleName(), ExceptionMessages.description(object), json);
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        long constructorsWithParameters = Stream.of(constructors).filter(constructor -> constructor.getParameterTypes().length > 0).count();
        if (constructorsWithParameters > 0L && (long)constructors.length == constructorsWithParameters) {
            message = message + "\nUse Johnzon @ConstructorProperties or @JsonbCreator if constructor arguments are needed";
        }
        message = message + "\n" + clazz + " not instantiable";
        return message;
    }
}

