/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.converter;

import jakarta.json.bind.annotation.JsonbNumberFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.johnzon.jsonb.converter.JsonbLocaleParserConverterBase;

public class JsonbNumberConverter
extends JsonbLocaleParserConverterBase<Number> {
    private final Supplier<NumberFormat> delegateFactory;
    private final Queue<NumberFormat> pool = new ArrayBlockingQueue<NumberFormat>(30);

    public JsonbNumberConverter(JsonbNumberFormat numberFormat) {
        boolean customLocale;
        String locale = numberFormat.locale();
        String format = numberFormat.value();
        boolean bl = customLocale = !"##default".equals(locale);
        this.delegateFactory = format.isEmpty() && customLocale ? () -> NumberFormat.getInstance(this.newLocale(locale)) : (format.isEmpty() ? NumberFormat::getInstance : (customLocale ? () -> new DecimalFormat(format, DecimalFormatSymbols.getInstance(this.newLocale(locale))) : () -> new DecimalFormat(format)));
    }

    @Override
    public String toString(Number instance) {
        return this.execute(f -> f.format(instance));
    }

    @Override
    public Number fromString(String text) {
        return this.execute(f -> {
            try {
                return f.parse(text);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Function<NumberFormat, T> function) {
        NumberFormat format = this.pool.poll();
        if (format == null) {
            format = this.delegateFactory.get();
        }
        try {
            T t = function.apply(format);
            return t;
        }
        finally {
            this.pool.add(format);
        }
    }
}

