/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb.converter;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.adapter.JsonbAdapter;
import java.lang.reflect.Type;
import org.apache.johnzon.mapper.TypeAwareAdapter;
import org.apache.johnzon.mapper.internal.AdapterKey;

public class JohnzonJsonbAdapter<JsonType, OriginalType>
implements TypeAwareAdapter<OriginalType, JsonType> {
    private final JsonbAdapter<OriginalType, JsonType> delegate;
    private final Type from;
    private final Type to;
    private final AdapterKey key;

    public JohnzonJsonbAdapter(JsonbAdapter<OriginalType, JsonType> delegate, Type from, Type to) {
        this.delegate = delegate;
        this.from = from;
        this.to = to;
        this.key = new AdapterKey(from, to);
    }

    @Override
    public OriginalType to(JsonType obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.delegate.adaptFromJson(obj);
        }
        catch (Exception e) {
            throw new JsonbException(e.getMessage(), e);
        }
    }

    @Override
    public JsonType from(OriginalType obj) {
        if (obj == null) {
            return null;
        }
        try {
            return this.delegate.adaptToJson(obj);
        }
        catch (Exception e) {
            throw new JsonbException(e.getMessage(), e);
        }
    }

    @Override
    public AdapterKey getKey() {
        return this.key;
    }

    @Override
    public Type getTo() {
        return this.to;
    }

    @Override
    public Type getFrom() {
        return this.from;
    }
}

