/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonb;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.math.BigDecimal;
import java.util.function.Supplier;
import org.apache.johnzon.mapper.jsonp.RewindableJsonParser;

class JsonValueParserAdapter<T extends JsonValue>
implements JsonParser {
    private final T jsonValue;

    public static JsonParser createFor(JsonValue jsonValue, Supplier<JsonParserFactory> parserFactoryProvider) {
        return new RewindableJsonParser(JsonValueParserAdapter.doCreate(jsonValue, parserFactoryProvider));
    }

    private static JsonParser doCreate(JsonValue jsonValue, Supplier<JsonParserFactory> parserFactoryProvider) {
        switch (jsonValue.getValueType()) {
            case OBJECT: {
                return parserFactoryProvider.get().createParser(jsonValue.asJsonObject());
            }
            case ARRAY: {
                return parserFactoryProvider.get().createParser(jsonValue.asJsonArray());
            }
            case STRING: {
                return new JsonStringParserAdapter((JsonString)jsonValue);
            }
            case NUMBER: {
                return new JsonNumberParserAdapter((JsonNumber)jsonValue);
            }
        }
        return new JsonValueParserAdapter<JsonValue>(jsonValue);
    }

    JsonValueParserAdapter(T jsonValue) {
        this.jsonValue = jsonValue;
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public JsonParser.Event next() {
        throw new UnsupportedOperationException("next() no supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public String getString() {
        throw new UnsupportedOperationException("next() no supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public boolean isIntegralNumber() {
        throw new UnsupportedOperationException("isIntegralNumber() not supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public int getInt() {
        throw new UnsupportedOperationException("getInt() not supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException("getLong() not supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public BigDecimal getBigDecimal() {
        throw new UnsupportedOperationException("getBigDecimal() not supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public JsonLocation getLocation() {
        throw new UnsupportedOperationException("getLocation() not supported for " + (Object)((Object)this.jsonValue.getValueType()));
    }

    @Override
    public void close() {
    }

    public T getValue() {
        return this.jsonValue;
    }

    private static class JsonNumberParserAdapter
    extends JsonValueParserAdapter<JsonNumber> {
        public JsonNumberParserAdapter(JsonNumber jsonValue) {
            super(jsonValue);
        }

        @Override
        public boolean isIntegralNumber() {
            return ((JsonNumber)this.getValue()).isIntegral();
        }

        @Override
        public int getInt() {
            return ((JsonNumber)this.getValue()).intValueExact();
        }

        @Override
        public long getLong() {
            return ((JsonNumber)this.getValue()).longValueExact();
        }

        @Override
        public BigDecimal getBigDecimal() {
            return ((JsonNumber)this.getValue()).bigDecimalValue();
        }
    }

    private static class JsonStringParserAdapter
    extends JsonValueParserAdapter<JsonString> {
        public JsonStringParserAdapter(JsonString jsonValue) {
            super(jsonValue);
        }

        @Override
        public String getString() {
            return ((JsonString)this.getValue()).getString();
        }
    }
}

